package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for an AlarmWidget.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AlarmWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {
    /**
     * The alarm to show.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.Alarm getAlarm();
    /**
     * Left Y axis.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis();

    /**
     * @return a {@link Builder} of {@link AlarmWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AlarmWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.cloudwatch.Alarm _alarm;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.YAxisProps _leftYAxis;
        @javax.annotation.Nullable
        private java.lang.Number _height;
        @javax.annotation.Nullable
        private java.lang.String _region;
        @javax.annotation.Nullable
        private java.lang.String _title;
        @javax.annotation.Nullable
        private java.lang.Number _width;

        /**
         * Sets the value of Alarm
         * @param value The alarm to show.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAlarm(final software.amazon.awscdk.services.cloudwatch.Alarm value) {
            this._alarm = java.util.Objects.requireNonNull(value, "alarm is required");
            return this;
        }
        /**
         * Sets the value of LeftYAxis
         * @param value Left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withLeftYAxis(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.YAxisProps value) {
            this._leftYAxis = value;
            return this;
        }
        /**
         * Sets the value of Height
         * @param value Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withHeight(@javax.annotation.Nullable final java.lang.Number value) {
            this._height = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }
        /**
         * Sets the value of Title
         * @param value Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withTitle(@javax.annotation.Nullable final java.lang.String value) {
            this._title = value;
            return this;
        }
        /**
         * Sets the value of Width
         * @param value Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withWidth(@javax.annotation.Nullable final java.lang.Number value) {
            this._width = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlarmWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AlarmWidgetProps build() {
            return new AlarmWidgetProps() {
                private final software.amazon.awscdk.services.cloudwatch.Alarm $alarm = java.util.Objects.requireNonNull(_alarm, "alarm is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.YAxisProps $leftYAxis = _leftYAxis;
                @javax.annotation.Nullable
                private final java.lang.Number $height = _height;
                @javax.annotation.Nullable
                private final java.lang.String $region = _region;
                @javax.annotation.Nullable
                private final java.lang.String $title = _title;
                @javax.annotation.Nullable
                private final java.lang.Number $width = _width;

                @Override
                public software.amazon.awscdk.services.cloudwatch.Alarm getAlarm() {
                    return this.$alarm;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
                    return this.$leftYAxis;
                }

                @Override
                public java.lang.Number getHeight() {
                    return this.$height;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                @Override
                public java.lang.String getTitle() {
                    return this.$title;
                }

                @Override
                public java.lang.Number getWidth() {
                    return this.$width;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("alarm", om.valueToTree(this.getAlarm()));
                    if (this.getLeftYAxis() != null) {
                        obj.set("leftYAxis", om.valueToTree(this.getLeftYAxis()));
                    }
                    if (this.getHeight() != null) {
                        obj.set("height", om.valueToTree(this.getHeight()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree(this.getRegion()));
                    }
                    if (this.getTitle() != null) {
                        obj.set("title", om.valueToTree(this.getTitle()));
                    }
                    if (this.getWidth() != null) {
                        obj.set("width", om.valueToTree(this.getWidth()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.AlarmWidgetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The alarm to show.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.cloudwatch.Alarm getAlarm() {
            return this.jsiiGet("alarm", software.amazon.awscdk.services.cloudwatch.Alarm.class);
        }

        /**
         * Left Y axis.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
            return this.jsiiGet("leftYAxis", software.amazon.awscdk.services.cloudwatch.YAxisProps.class);
        }

        /**
         * Height of the widget.
         * 
         * Default: Depends on the type of widget
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getHeight() {
            return this.jsiiGet("height", java.lang.Number.class);
        }

        /**
         * The region the metrics of this graph should be taken from.
         * 
         * Default: Current region
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }

        /**
         * Title for the graph.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getTitle() {
            return this.jsiiGet("title", java.lang.String.class);
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * 
         * Default: 6
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getWidth() {
            return this.jsiiGet("width", java.lang.Number.class);
        }
    }
}
