package software.amazon.awscdk.services.cloudwatch;

/**
 * Horizontal annotation to be added to a graph.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.756Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HorizontalAnnotation extends software.amazon.jsii.JsiiSerializable {
    /**
     * The value of the annotation.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getValue();
    /**
     * Hex color code to be used for the annotation.
     * 
     * Default: Automatic color
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getColor();
    /**
     * Add shading above or below the annotation.
     * 
     * Default: No shading
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.Shading getFill();
    /**
     * Label for the annotation.
     * 
     * Default: No label
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getLabel();
    /**
     * Whether the annotation is visible.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getVisible();

    /**
     * @return a {@link Builder} of {@link HorizontalAnnotation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HorizontalAnnotation}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.Number _value;
        @javax.annotation.Nullable
        private java.lang.String _color;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.Shading _fill;
        @javax.annotation.Nullable
        private java.lang.String _label;
        @javax.annotation.Nullable
        private java.lang.Boolean _visible;

        /**
         * Sets the value of Value
         * @param value The value of the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withValue(final java.lang.Number value) {
            this._value = java.util.Objects.requireNonNull(value, "value is required");
            return this;
        }
        /**
         * Sets the value of Color
         * @param value Hex color code to be used for the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withColor(@javax.annotation.Nullable final java.lang.String value) {
            this._color = value;
            return this;
        }
        /**
         * Sets the value of Fill
         * @param value Add shading above or below the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withFill(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.Shading value) {
            this._fill = value;
            return this;
        }
        /**
         * Sets the value of Label
         * @param value Label for the annotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withLabel(@javax.annotation.Nullable final java.lang.String value) {
            this._label = value;
            return this;
        }
        /**
         * Sets the value of Visible
         * @param value Whether the annotation is visible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withVisible(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._visible = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HorizontalAnnotation}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public HorizontalAnnotation build() {
            return new HorizontalAnnotation() {
                private final java.lang.Number $value = java.util.Objects.requireNonNull(_value, "value is required");
                @javax.annotation.Nullable
                private final java.lang.String $color = _color;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.Shading $fill = _fill;
                @javax.annotation.Nullable
                private final java.lang.String $label = _label;
                @javax.annotation.Nullable
                private final java.lang.Boolean $visible = _visible;

                @Override
                public java.lang.Number getValue() {
                    return this.$value;
                }

                @Override
                public java.lang.String getColor() {
                    return this.$color;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.Shading getFill() {
                    return this.$fill;
                }

                @Override
                public java.lang.String getLabel() {
                    return this.$label;
                }

                @Override
                public java.lang.Boolean getVisible() {
                    return this.$visible;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("value", om.valueToTree(this.getValue()));
                    if (this.getColor() != null) {
                        obj.set("color", om.valueToTree(this.getColor()));
                    }
                    if (this.getFill() != null) {
                        obj.set("fill", om.valueToTree(this.getFill()));
                    }
                    if (this.getLabel() != null) {
                        obj.set("label", om.valueToTree(this.getLabel()));
                    }
                    if (this.getVisible() != null) {
                        obj.set("visible", om.valueToTree(this.getVisible()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The value of the annotation.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getValue() {
            return this.jsiiGet("value", java.lang.Number.class);
        }

        /**
         * Hex color code to be used for the annotation.
         * 
         * Default: Automatic color
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getColor() {
            return this.jsiiGet("color", java.lang.String.class);
        }

        /**
         * Add shading above or below the annotation.
         * 
         * Default: No shading
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.Shading getFill() {
            return this.jsiiGet("fill", software.amazon.awscdk.services.cloudwatch.Shading.class);
        }

        /**
         * Label for the annotation.
         * 
         * Default: No label
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getLabel() {
            return this.jsiiGet("label", java.lang.String.class);
        }

        /**
         * Whether the annotation is visible.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getVisible() {
            return this.jsiiGet("visible", java.lang.Boolean.class);
        }
    }
}
