package software.amazon.awscdk.services.cloudwatch;

/**
 * A metric emitted by a service.
 * 
 * The metric is a combination of a metric identifier (namespace, name and dimensions)
 * and an aggregation function (statistic, period and unit).
 * 
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 * 
 * This class does not represent a resource, so hence is not a construct. Instead,
 * Metric is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.758Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.$Module.class, fqn = "@aws-cdk/aws-cloudwatch.Metric")
public class Metric extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IMetric {
    protected Metric(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Metric(final software.amazon.awscdk.services.cloudwatch.MetricProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant permissions to the given identity to write metrics.
     * 
     * EXPERIMENTAL
     * 
     * @param grantee The IAM identity to give permissions to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static software.amazon.awscdk.services.iam.Grant grantPutMetricData(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Metric.class, "grantPutMetricData", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Make a new Alarm for this metric.
     * 
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Alarm createAlarm(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions props) {
        return this.jsiiCall("createAlarm", software.amazon.awscdk.services.cloudwatch.Alarm.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Turn this metric object into an alarm configuration.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.cloudwatch.MetricAlarmConfig toAlarmConfig() {
        return this.jsiiCall("toAlarmConfig", software.amazon.awscdk.services.cloudwatch.MetricAlarmConfig.class);
    }

    /**
     * Turn this metric object into a graph configuration.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.cloudwatch.MetricGraphConfig toGraphConfig() {
        return this.jsiiCall("toGraphConfig", software.amazon.awscdk.services.cloudwatch.MetricGraphConfig.class);
    }

    /**
     * Returns a string representation of an object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Return a copy of Metric with properties changed.
     * 
     * All properties except namespace and metricName can be changed.
     * 
     * EXPERIMENTAL
     * 
     * @param props The set of properties to change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.cloudwatch.Metric with(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("with", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getMetricName() {
        return this.jsiiGet("metricName", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getNamespace() {
        return this.jsiiGet("namespace", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.core.Duration getPeriod() {
        return this.jsiiGet("period", software.amazon.awscdk.core.Duration.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getStatistic() {
        return this.jsiiGet("statistic", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public java.lang.String getColor() {
        return this.jsiiGet("color", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
        return this.jsiiGet("dimensions", java.util.Map.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public java.lang.String getLabel() {
        return this.jsiiGet("label", java.lang.String.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
        return this.jsiiGet("unit", software.amazon.awscdk.services.cloudwatch.Unit.class);
    }
}
