package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties used to construct the Metric identifying part of an Alarm.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.761Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MetricAlarmConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * Name of the metric.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMetricName();
    /**
     * Namespace of the metric.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getNamespace();
    /**
     * How many seconds to aggregate over.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getPeriod();
    /**
     * The dimensions to apply to the alarm.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions();
    /**
     * Percentile aggregation function to use.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getExtendedStatistic();
    /**
     * Simple aggregation function to use.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.Statistic getStatistic();
    /**
     * The unit of the alarm.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.Unit getUnit();

    /**
     * @return a {@link Builder} of {@link MetricAlarmConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MetricAlarmConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _metricName;
        private java.lang.String _namespace;
        private java.lang.Number _period;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> _dimensions;
        @javax.annotation.Nullable
        private java.lang.String _extendedStatistic;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.Statistic _statistic;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.Unit _unit;

        /**
         * Sets the value of MetricName
         * @param value Name of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetricName(final java.lang.String value) {
            this._metricName = java.util.Objects.requireNonNull(value, "metricName is required");
            return this;
        }
        /**
         * Sets the value of Namespace
         * @param value Namespace of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withNamespace(final java.lang.String value) {
            this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
            return this;
        }
        /**
         * Sets the value of Period
         * @param value How many seconds to aggregate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPeriod(final java.lang.Number value) {
            this._period = java.util.Objects.requireNonNull(value, "period is required");
            return this;
        }
        /**
         * Sets the value of Dimensions
         * @param value The dimensions to apply to the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDimensions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> value) {
            this._dimensions = value;
            return this;
        }
        /**
         * Sets the value of ExtendedStatistic
         * @param value Percentile aggregation function to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withExtendedStatistic(@javax.annotation.Nullable final java.lang.String value) {
            this._extendedStatistic = value;
            return this;
        }
        /**
         * Sets the value of Statistic
         * @param value Simple aggregation function to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStatistic(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.Statistic value) {
            this._statistic = value;
            return this;
        }
        /**
         * Sets the value of Unit
         * @param value The unit of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withUnit(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.Unit value) {
            this._unit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricAlarmConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public MetricAlarmConfig build() {
            return new MetricAlarmConfig() {
                private final java.lang.String $metricName = java.util.Objects.requireNonNull(_metricName, "metricName is required");
                private final java.lang.String $namespace = java.util.Objects.requireNonNull(_namespace, "namespace is required");
                private final java.lang.Number $period = java.util.Objects.requireNonNull(_period, "period is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> $dimensions = _dimensions;
                @javax.annotation.Nullable
                private final java.lang.String $extendedStatistic = _extendedStatistic;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.Statistic $statistic = _statistic;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.Unit $unit = _unit;

                @Override
                public java.lang.String getMetricName() {
                    return this.$metricName;
                }

                @Override
                public java.lang.String getNamespace() {
                    return this.$namespace;
                }

                @Override
                public java.lang.Number getPeriod() {
                    return this.$period;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
                    return this.$dimensions;
                }

                @Override
                public java.lang.String getExtendedStatistic() {
                    return this.$extendedStatistic;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.Statistic getStatistic() {
                    return this.$statistic;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
                    return this.$unit;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("metricName", om.valueToTree(this.getMetricName()));
                    obj.set("namespace", om.valueToTree(this.getNamespace()));
                    obj.set("period", om.valueToTree(this.getPeriod()));
                    if (this.getDimensions() != null) {
                        obj.set("dimensions", om.valueToTree(this.getDimensions()));
                    }
                    if (this.getExtendedStatistic() != null) {
                        obj.set("extendedStatistic", om.valueToTree(this.getExtendedStatistic()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree(this.getStatistic()));
                    }
                    if (this.getUnit() != null) {
                        obj.set("unit", om.valueToTree(this.getUnit()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.MetricAlarmConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Name of the metric.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getMetricName() {
            return this.jsiiGet("metricName", java.lang.String.class);
        }

        /**
         * Namespace of the metric.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getNamespace() {
            return this.jsiiGet("namespace", java.lang.String.class);
        }

        /**
         * How many seconds to aggregate over.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getPeriod() {
            return this.jsiiGet("period", java.lang.Number.class);
        }

        /**
         * The dimensions to apply to the alarm.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
            return this.jsiiGet("dimensions", java.util.List.class);
        }

        /**
         * Percentile aggregation function to use.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getExtendedStatistic() {
            return this.jsiiGet("extendedStatistic", java.lang.String.class);
        }

        /**
         * Simple aggregation function to use.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.Statistic getStatistic() {
            return this.jsiiGet("statistic", software.amazon.awscdk.services.cloudwatch.Statistic.class);
        }

        /**
         * The unit of the alarm.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.jsiiGet("unit", software.amazon.awscdk.services.cloudwatch.Unit.class);
        }
    }
}
