package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties used to construct the Metric identifying part of a Graph.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:58:11.761Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MetricGraphConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * Name of the metric.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getMetricName();
    /**
     * Namespace of the metric.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getNamespace();
    /**
     * How many seconds to aggregate over.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getPeriod();
    /**
     * Color for the graph line.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getColor();
    /**
     * The dimensions to apply to the alarm.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions();
    /**
     * Label for the metric.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getLabel();
    /**
     * Aggregation function to use (can be either simple or a percentile).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getStatistic();
    /**
     * The unit of the alarm.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.cloudwatch.Unit getUnit();

    /**
     * @return a {@link Builder} of {@link MetricGraphConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link MetricGraphConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _metricName;
        private java.lang.String _namespace;
        private java.lang.Number _period;
        @javax.annotation.Nullable
        private java.lang.String _color;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> _dimensions;
        @javax.annotation.Nullable
        private java.lang.String _label;
        @javax.annotation.Nullable
        private java.lang.String _statistic;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.cloudwatch.Unit _unit;

        /**
         * Sets the value of MetricName
         * @param value Name of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMetricName(final java.lang.String value) {
            this._metricName = java.util.Objects.requireNonNull(value, "metricName is required");
            return this;
        }
        /**
         * Sets the value of Namespace
         * @param value Namespace of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withNamespace(final java.lang.String value) {
            this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
            return this;
        }
        /**
         * Sets the value of Period
         * @param value How many seconds to aggregate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPeriod(final java.lang.Number value) {
            this._period = java.util.Objects.requireNonNull(value, "period is required");
            return this;
        }
        /**
         * Sets the value of Color
         * @param value Color for the graph line.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withColor(@javax.annotation.Nullable final java.lang.String value) {
            this._color = value;
            return this;
        }
        /**
         * Sets the value of Dimensions
         * @param value The dimensions to apply to the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDimensions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> value) {
            this._dimensions = value;
            return this;
        }
        /**
         * Sets the value of Label
         * @param value Label for the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withLabel(@javax.annotation.Nullable final java.lang.String value) {
            this._label = value;
            return this;
        }
        /**
         * Sets the value of Statistic
         * @param value Aggregation function to use (can be either simple or a percentile).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStatistic(@javax.annotation.Nullable final java.lang.String value) {
            this._statistic = value;
            return this;
        }
        /**
         * Sets the value of Unit
         * @param value The unit of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withUnit(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.Unit value) {
            this._unit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricGraphConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public MetricGraphConfig build() {
            return new MetricGraphConfig() {
                private final java.lang.String $metricName = java.util.Objects.requireNonNull(_metricName, "metricName is required");
                private final java.lang.String $namespace = java.util.Objects.requireNonNull(_namespace, "namespace is required");
                private final java.lang.Number $period = java.util.Objects.requireNonNull(_period, "period is required");
                @javax.annotation.Nullable
                private final java.lang.String $color = _color;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> $dimensions = _dimensions;
                @javax.annotation.Nullable
                private final java.lang.String $label = _label;
                @javax.annotation.Nullable
                private final java.lang.String $statistic = _statistic;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.cloudwatch.Unit $unit = _unit;

                @Override
                public java.lang.String getMetricName() {
                    return this.$metricName;
                }

                @Override
                public java.lang.String getNamespace() {
                    return this.$namespace;
                }

                @Override
                public java.lang.Number getPeriod() {
                    return this.$period;
                }

                @Override
                public java.lang.String getColor() {
                    return this.$color;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
                    return this.$dimensions;
                }

                @Override
                public java.lang.String getLabel() {
                    return this.$label;
                }

                @Override
                public java.lang.String getStatistic() {
                    return this.$statistic;
                }

                @Override
                public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
                    return this.$unit;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("metricName", om.valueToTree(this.getMetricName()));
                    obj.set("namespace", om.valueToTree(this.getNamespace()));
                    obj.set("period", om.valueToTree(this.getPeriod()));
                    if (this.getColor() != null) {
                        obj.set("color", om.valueToTree(this.getColor()));
                    }
                    if (this.getDimensions() != null) {
                        obj.set("dimensions", om.valueToTree(this.getDimensions()));
                    }
                    if (this.getLabel() != null) {
                        obj.set("label", om.valueToTree(this.getLabel()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree(this.getStatistic()));
                    }
                    if (this.getUnit() != null) {
                        obj.set("unit", om.valueToTree(this.getUnit()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.MetricGraphConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Name of the metric.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getMetricName() {
            return this.jsiiGet("metricName", java.lang.String.class);
        }

        /**
         * Namespace of the metric.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getNamespace() {
            return this.jsiiGet("namespace", java.lang.String.class);
        }

        /**
         * How many seconds to aggregate over.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.Number getPeriod() {
            return this.jsiiGet("period", java.lang.Number.class);
        }

        /**
         * Color for the graph line.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getColor() {
            return this.jsiiGet("color", java.lang.String.class);
        }

        /**
         * The dimensions to apply to the alarm.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.Dimension> getDimensions() {
            return this.jsiiGet("dimensions", java.util.List.class);
        }

        /**
         * Label for the metric.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getLabel() {
            return this.jsiiGet("label", java.lang.String.class);
        }

        /**
         * Aggregation function to use (can be either simple or a percentile).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getStatistic() {
            return this.jsiiGet("statistic", java.lang.String.class);
        }

        /**
         * The unit of the alarm.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.jsiiGet("unit", software.amazon.awscdk.services.cloudwatch.Unit.class);
        }
    }
}
