/**
 * <h2>Amazon CloudWatch Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>Metric objects represent a metric that is emitted by AWS services or your own
 * application, such as <code>CPUUsage</code>, <code>FailureCount</code> or <code>Bandwidth</code>.</p>
 * <p>Metric objects can be constructed directly or are exposed by resources as
 * attributes. Resources that expose metrics will have functions that look
 * like <code>metricXxx()</code> which will return a Metric object, initialized with defaults
 * that make sense.</p>
 * <p>For example, <code>lambda.Function</code> objects have the <code>fn.metricErrors()</code> method, which
 * represents the amount of errors reported by that Lambda function:</p>
 * <pre><code class="language-ts">const errors = fn.metricErrors();
 * </code></pre>
 * <h3>Aggregation</h3>
 * <p>To graph or alarm on metrics you must aggregate them first, using a function
 * like <code>Average</code> or a percentile function like <code>P99</code>. By default, most Metric objects
 * returned by CDK libraries will be configured as <code>Average</code> over <code>300 seconds</code> (5 minutes).
 * The exception is if the metric represents a count of discrete events, such as
 * failures. In that case, the Metric object will be configured as <code>Sum</code> over <code>300 seconds</code>, i.e. it represents the number of times that event occurred over the
 * time period.</p>
 * <p>If you want to change the default aggregation of the Metric object (for example,
 * the function or the period), you can do so by passing additional parameters
 * to the metric function call:</p>
 * <pre><code class="language-ts">const minuteErrorRate = fn.metricErrors({
 *     statistic: 'avg',
 *     periodSec: 60,
 *     label: 'Lambda failure rate'
 * });
 * </code></pre>
 * <p>This function also allows changing the metric label or color (which will be
 * useful when embedding them in graphs, see below).</p>
 * <blockquote>
 * <p>Rates versus Sums</p>
 * <p>The reason for using <code>Sum</code> to count discrete events is that <em>some</em> events are
 * emitted as either <code>0</code> or <code>1</code> (for example <code>Errors</code> for a Lambda) and some are
 * only emitted as <code>1</code> (for example <code>NumberOfMessagesPublished</code> for an SNS
 * topic).</p>
 * <p>In case <code>0</code>-metrics are emitted, it makes sense to take the <code>Average</code> of this
 * metric: the result will be the fraction of errors over all executions.</p>
 * <p>If <code>0</code>-metrics are not emitted, the <code>Average</code> will always be equal to <code>1</code>,
 * and not be very useful.</p>
 * <p>In order to simplify the mental model of <code>Metric</code> objects, we default to
 * aggregating using <code>Sum</code>, which will be the same for both metrics types. If you
 * happen to know the Metric you want to alarm on makes sense as a rate
 * (<code>Average</code>) you can always choose to change the statistic.</p>
 * </blockquote>
 * <h2>Alarms</h2>
 * <p>Alarms can be created on metrics in one of two ways. Either create an <code>Alarm</code>
 * object, passing the <code>Metric</code> object to set the alarm on:</p>
 * <pre><code class="language-ts">new Alarm(this, 'Alarm', {
 *     metric: fn.metricErrors(),
 *     threshold: 100,
 *     evaluationPeriods: 2,
 * });
 * </code></pre>
 * <p>Alternatively, you can call <code>metric.newAlarm()</code>:</p>
 * <pre><code class="language-ts">fn.metricErrors().newAlarm(this, 'Alarm', {
 *     threshold: 100,
 *     evaluationPeriods: 2,
 * });
 * </code></pre>
 * <p>The most important properties to set while creating an Alarms are:</p>
 * <ul>
 * <li><code>threshold</code>: the value to compare the metric against.</li>
 * <li><code>comparisonOperator</code>: the comparison operation to use, defaults to <code>metric &gt;= threshold</code>.</li>
 * <li><code>evaluationPeriods</code>: how many consecutive periods the metric has to be
 * breaching the the threshold for the alarm to trigger.</li>
 * </ul>
 * <h2>Dashboards</h2>
 * <p>Dashboards are set of Widgets stored server-side which can be accessed quickly
 * from the AWS console. Available widgets are graphs of a metric over time, the
 * current value of a metric, or a static piece of Markdown which explains what the
 * graphs mean.</p>
 * <p>The following widgets are available:</p>
 * <ul>
 * <li><code>GraphWidget</code> -- shows any number of metrics on both the left and right
 * vertical axes.</li>
 * <li><code>AlarmWidget</code> -- shows the graph and alarm line for a single alarm.</li>
 * <li><code>SingleValueWidget</code> -- shows the current value of a set of metrics.</li>
 * <li><code>TextWidget</code> -- shows some static Markdown.</li>
 * </ul>
 * <h3>Graph widget</h3>
 * <p>A graph widget can display any number of metrics on either the <code>left</code> or
 * <code>right</code> vertical axis:</p>
 * <pre><code class="language-ts">dashboard.add(new GraphWidget({
 *     title: &quot;Executions vs error rate&quot;,
 * 
 *     left: [executionCountMetric],
 * 
 *     right: [errorCountMetric.with({
 *         statistic: &quot;average&quot;,
 *         label: &quot;Error rate&quot;,
 *         color: &quot;00FF00&quot;
 *     })]
 * }));
 * </code></pre>
 * <h3>Alarm widget</h3>
 * <p>An alarm widget shows the graph and the alarm line of a single alarm:</p>
 * <pre><code class="language-ts">dashboard.add(new AlarmWidget({
 *     title: &quot;Errors&quot;,
 *     alarm: errorAlarm,
 * }));
 * </code></pre>
 * <h3>Single value widget</h3>
 * <p>A single-value widget shows the latest value of a set of metrics (as opposed
 * to a graph of the value over time):</p>
 * <pre><code class="language-ts">dashboard.add(new SingleValueWidget({
 *     metrics: [visitorCount, purchaseCount],
 * }));
 * </code></pre>
 * <h3>Text widget</h3>
 * <p>A text widget shows an arbitrary piece of MarkDown. Use this to add explanations
 * to your dashboard:</p>
 * <pre><code class="language-ts">dashboard.add(new TextWidget({
 *     markdown: '# Key Performance Indicators'
 * }));
 * </code></pre>
 * <h3>Dashboard Layout</h3>
 * <p>The widgets on a dashboard are visually laid out in a grid that is 24 columns
 * wide. Normally you specify X and Y coordinates for the widgets on a Dashboard,
 * but because this is inconvenient to do manually, the library contains a simple
 * layout system to help you lay out your dashboards the way you want them to.</p>
 * <p>Widgets have a <code>width</code> and <code>height</code> property, and they will be automatically
 * laid out either horizontally or vertically stacked to fill out the available
 * space.</p>
 * <p>Widgets are added to a Dashboard by calling <code>add(widget1, widget2, ...)</code>.
 * Widgets given in the same call will be laid out horizontally. Widgets given
 * in different calls will be laid out vertically. To make more complex layouts,
 * you can use the following widgets to pack widgets together in different ways:</p>
 * <ul>
 * <li><code>Column</code>: stack two or more widgets vertically.</li>
 * <li><code>Row</code>: lay out two or more widgets horizontally.</li>
 * <li><code>Spacer</code>: take up empty space</li>
 * </ul>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.cloudwatch;
