/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.ComparisonOperator;
import software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.TreatMissingData;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AlarmProps
extends JsiiSerializable,
CreateAlarmOptions {
    public IMetric getMetric();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IMetric _metric;
        private Number _evaluationPeriods;
        private Number _threshold;
        @Nullable
        private Boolean _actionsEnabled;
        @Nullable
        private String _alarmDescription;
        @Nullable
        private String _alarmName;
        @Nullable
        private ComparisonOperator _comparisonOperator;
        @Nullable
        private Number _datapointsToAlarm;
        @Nullable
        private String _evaluateLowSampleCountPercentile;
        @Nullable
        private Duration _period;
        @Nullable
        private String _statistic;
        @Nullable
        private TreatMissingData _treatMissingData;

        public Builder withMetric(IMetric value) {
            this._metric = Objects.requireNonNull(value, "metric is required");
            return this;
        }

        public Builder withEvaluationPeriods(Number value) {
            this._evaluationPeriods = Objects.requireNonNull(value, "evaluationPeriods is required");
            return this;
        }

        public Builder withThreshold(Number value) {
            this._threshold = Objects.requireNonNull(value, "threshold is required");
            return this;
        }

        public Builder withActionsEnabled(@Nullable Boolean value) {
            this._actionsEnabled = value;
            return this;
        }

        public Builder withAlarmDescription(@Nullable String value) {
            this._alarmDescription = value;
            return this;
        }

        public Builder withAlarmName(@Nullable String value) {
            this._alarmName = value;
            return this;
        }

        public Builder withComparisonOperator(@Nullable ComparisonOperator value) {
            this._comparisonOperator = value;
            return this;
        }

        public Builder withDatapointsToAlarm(@Nullable Number value) {
            this._datapointsToAlarm = value;
            return this;
        }

        public Builder withEvaluateLowSampleCountPercentile(@Nullable String value) {
            this._evaluateLowSampleCountPercentile = value;
            return this;
        }

        public Builder withPeriod(@Nullable Duration value) {
            this._period = value;
            return this;
        }

        public Builder withStatistic(@Nullable String value) {
            this._statistic = value;
            return this;
        }

        public Builder withTreatMissingData(@Nullable TreatMissingData value) {
            this._treatMissingData = value;
            return this;
        }

        public AlarmProps build() {
            return new AlarmProps(){
                private final IMetric $metric;
                private final Number $evaluationPeriods;
                private final Number $threshold;
                @Nullable
                private final Boolean $actionsEnabled;
                @Nullable
                private final String $alarmDescription;
                @Nullable
                private final String $alarmName;
                @Nullable
                private final ComparisonOperator $comparisonOperator;
                @Nullable
                private final Number $datapointsToAlarm;
                @Nullable
                private final String $evaluateLowSampleCountPercentile;
                @Nullable
                private final Duration $period;
                @Nullable
                private final String $statistic;
                @Nullable
                private final TreatMissingData $treatMissingData;
                {
                    this.$metric = Objects.requireNonNull(_metric, "metric is required");
                    this.$evaluationPeriods = Objects.requireNonNull(_evaluationPeriods, "evaluationPeriods is required");
                    this.$threshold = Objects.requireNonNull(_threshold, "threshold is required");
                    this.$actionsEnabled = _actionsEnabled;
                    this.$alarmDescription = _alarmDescription;
                    this.$alarmName = _alarmName;
                    this.$comparisonOperator = _comparisonOperator;
                    this.$datapointsToAlarm = _datapointsToAlarm;
                    this.$evaluateLowSampleCountPercentile = _evaluateLowSampleCountPercentile;
                    this.$period = _period;
                    this.$statistic = _statistic;
                    this.$treatMissingData = _treatMissingData;
                }

                @Override
                public IMetric getMetric() {
                    return this.$metric;
                }

                @Override
                public Number getEvaluationPeriods() {
                    return this.$evaluationPeriods;
                }

                @Override
                public Number getThreshold() {
                    return this.$threshold;
                }

                @Override
                public Boolean getActionsEnabled() {
                    return this.$actionsEnabled;
                }

                @Override
                public String getAlarmDescription() {
                    return this.$alarmDescription;
                }

                @Override
                public String getAlarmName() {
                    return this.$alarmName;
                }

                @Override
                public ComparisonOperator getComparisonOperator() {
                    return this.$comparisonOperator;
                }

                @Override
                public Number getDatapointsToAlarm() {
                    return this.$datapointsToAlarm;
                }

                @Override
                public String getEvaluateLowSampleCountPercentile() {
                    return this.$evaluateLowSampleCountPercentile;
                }

                @Override
                public Duration getPeriod() {
                    return this.$period;
                }

                @Override
                public String getStatistic() {
                    return this.$statistic;
                }

                @Override
                public TreatMissingData getTreatMissingData() {
                    return this.$treatMissingData;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("metric", om.valueToTree((Object)this.getMetric()));
                    obj.set("evaluationPeriods", om.valueToTree((Object)this.getEvaluationPeriods()));
                    obj.set("threshold", om.valueToTree((Object)this.getThreshold()));
                    if (this.getActionsEnabled() != null) {
                        obj.set("actionsEnabled", om.valueToTree((Object)this.getActionsEnabled()));
                    }
                    if (this.getAlarmDescription() != null) {
                        obj.set("alarmDescription", om.valueToTree((Object)this.getAlarmDescription()));
                    }
                    if (this.getAlarmName() != null) {
                        obj.set("alarmName", om.valueToTree((Object)this.getAlarmName()));
                    }
                    if (this.getComparisonOperator() != null) {
                        obj.set("comparisonOperator", om.valueToTree((Object)this.getComparisonOperator()));
                    }
                    if (this.getDatapointsToAlarm() != null) {
                        obj.set("datapointsToAlarm", om.valueToTree((Object)this.getDatapointsToAlarm()));
                    }
                    if (this.getEvaluateLowSampleCountPercentile() != null) {
                        obj.set("evaluateLowSampleCountPercentile", om.valueToTree((Object)this.getEvaluateLowSampleCountPercentile()));
                    }
                    if (this.getPeriod() != null) {
                        obj.set("period", om.valueToTree((Object)this.getPeriod()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree((Object)this.getStatistic()));
                    }
                    if (this.getTreatMissingData() != null) {
                        obj.set("treatMissingData", om.valueToTree((Object)this.getTreatMissingData()));
                    }
                    return obj;
                }
            };
        }
    }
}

