/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.cloudwatch.MetricWidgetProps;
import software.amazon.awscdk.services.cloudwatch.YAxisProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AlarmWidgetProps
extends JsiiSerializable,
MetricWidgetProps {
    public Alarm getAlarm();

    public YAxisProps getLeftYAxis();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Alarm _alarm;
        @Nullable
        private YAxisProps _leftYAxis;
        @Nullable
        private Number _height;
        @Nullable
        private String _region;
        @Nullable
        private String _title;
        @Nullable
        private Number _width;

        public Builder withAlarm(Alarm value) {
            this._alarm = Objects.requireNonNull(value, "alarm is required");
            return this;
        }

        public Builder withLeftYAxis(@Nullable YAxisProps value) {
            this._leftYAxis = value;
            return this;
        }

        public Builder withHeight(@Nullable Number value) {
            this._height = value;
            return this;
        }

        public Builder withRegion(@Nullable String value) {
            this._region = value;
            return this;
        }

        public Builder withTitle(@Nullable String value) {
            this._title = value;
            return this;
        }

        public Builder withWidth(@Nullable Number value) {
            this._width = value;
            return this;
        }

        public AlarmWidgetProps build() {
            return new AlarmWidgetProps(){
                private final Alarm $alarm;
                @Nullable
                private final YAxisProps $leftYAxis;
                @Nullable
                private final Number $height;
                @Nullable
                private final String $region;
                @Nullable
                private final String $title;
                @Nullable
                private final Number $width;
                {
                    this.$alarm = Objects.requireNonNull(_alarm, "alarm is required");
                    this.$leftYAxis = _leftYAxis;
                    this.$height = _height;
                    this.$region = _region;
                    this.$title = _title;
                    this.$width = _width;
                }

                @Override
                public Alarm getAlarm() {
                    return this.$alarm;
                }

                @Override
                public YAxisProps getLeftYAxis() {
                    return this.$leftYAxis;
                }

                @Override
                public Number getHeight() {
                    return this.$height;
                }

                @Override
                public String getRegion() {
                    return this.$region;
                }

                @Override
                public String getTitle() {
                    return this.$title;
                }

                @Override
                public Number getWidth() {
                    return this.$width;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("alarm", om.valueToTree((Object)this.getAlarm()));
                    if (this.getLeftYAxis() != null) {
                        obj.set("leftYAxis", om.valueToTree((Object)this.getLeftYAxis()));
                    }
                    if (this.getHeight() != null) {
                        obj.set("height", om.valueToTree((Object)this.getHeight()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree((Object)this.getRegion()));
                    }
                    if (this.getTitle() != null) {
                        obj.set("title", om.valueToTree((Object)this.getTitle()));
                    }
                    if (this.getWidth() != null) {
                        obj.set("width", om.valueToTree((Object)this.getWidth()));
                    }
                    return obj;
                }
            };
        }
    }
}

