/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnAlarmProps
extends JsiiSerializable {
    public String getComparisonOperator();

    public Number getEvaluationPeriods();

    public Number getThreshold();

    public Object getActionsEnabled();

    public List<String> getAlarmActions();

    public String getAlarmDescription();

    public String getAlarmName();

    public Number getDatapointsToAlarm();

    public Object getDimensions();

    public String getEvaluateLowSampleCountPercentile();

    public String getExtendedStatistic();

    public List<String> getInsufficientDataActions();

    public String getMetricName();

    public Object getMetrics();

    public String getNamespace();

    public List<String> getOkActions();

    public Number getPeriod();

    public String getStatistic();

    public String getTreatMissingData();

    public String getUnit();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _comparisonOperator;
        private Number _evaluationPeriods;
        private Number _threshold;
        @Nullable
        private Object _actionsEnabled;
        @Nullable
        private List<String> _alarmActions;
        @Nullable
        private String _alarmDescription;
        @Nullable
        private String _alarmName;
        @Nullable
        private Number _datapointsToAlarm;
        @Nullable
        private Object _dimensions;
        @Nullable
        private String _evaluateLowSampleCountPercentile;
        @Nullable
        private String _extendedStatistic;
        @Nullable
        private List<String> _insufficientDataActions;
        @Nullable
        private String _metricName;
        @Nullable
        private Object _metrics;
        @Nullable
        private String _namespace;
        @Nullable
        private List<String> _okActions;
        @Nullable
        private Number _period;
        @Nullable
        private String _statistic;
        @Nullable
        private String _treatMissingData;
        @Nullable
        private String _unit;

        public Builder withComparisonOperator(String value) {
            this._comparisonOperator = Objects.requireNonNull(value, "comparisonOperator is required");
            return this;
        }

        public Builder withEvaluationPeriods(Number value) {
            this._evaluationPeriods = Objects.requireNonNull(value, "evaluationPeriods is required");
            return this;
        }

        public Builder withThreshold(Number value) {
            this._threshold = Objects.requireNonNull(value, "threshold is required");
            return this;
        }

        public Builder withActionsEnabled(@Nullable Boolean value) {
            this._actionsEnabled = value;
            return this;
        }

        public Builder withActionsEnabled(@Nullable IResolvable value) {
            this._actionsEnabled = value;
            return this;
        }

        public Builder withAlarmActions(@Nullable List<String> value) {
            this._alarmActions = value;
            return this;
        }

        public Builder withAlarmDescription(@Nullable String value) {
            this._alarmDescription = value;
            return this;
        }

        public Builder withAlarmName(@Nullable String value) {
            this._alarmName = value;
            return this;
        }

        public Builder withDatapointsToAlarm(@Nullable Number value) {
            this._datapointsToAlarm = value;
            return this;
        }

        public Builder withDimensions(@Nullable IResolvable value) {
            this._dimensions = value;
            return this;
        }

        public Builder withDimensions(@Nullable List<Object> value) {
            this._dimensions = value;
            return this;
        }

        public Builder withEvaluateLowSampleCountPercentile(@Nullable String value) {
            this._evaluateLowSampleCountPercentile = value;
            return this;
        }

        public Builder withExtendedStatistic(@Nullable String value) {
            this._extendedStatistic = value;
            return this;
        }

        public Builder withInsufficientDataActions(@Nullable List<String> value) {
            this._insufficientDataActions = value;
            return this;
        }

        public Builder withMetricName(@Nullable String value) {
            this._metricName = value;
            return this;
        }

        public Builder withMetrics(@Nullable IResolvable value) {
            this._metrics = value;
            return this;
        }

        public Builder withMetrics(@Nullable List<Object> value) {
            this._metrics = value;
            return this;
        }

        public Builder withNamespace(@Nullable String value) {
            this._namespace = value;
            return this;
        }

        public Builder withOkActions(@Nullable List<String> value) {
            this._okActions = value;
            return this;
        }

        public Builder withPeriod(@Nullable Number value) {
            this._period = value;
            return this;
        }

        public Builder withStatistic(@Nullable String value) {
            this._statistic = value;
            return this;
        }

        public Builder withTreatMissingData(@Nullable String value) {
            this._treatMissingData = value;
            return this;
        }

        public Builder withUnit(@Nullable String value) {
            this._unit = value;
            return this;
        }

        public CfnAlarmProps build() {
            return new CfnAlarmProps(){
                private final String $comparisonOperator;
                private final Number $evaluationPeriods;
                private final Number $threshold;
                @Nullable
                private final Object $actionsEnabled;
                @Nullable
                private final List<String> $alarmActions;
                @Nullable
                private final String $alarmDescription;
                @Nullable
                private final String $alarmName;
                @Nullable
                private final Number $datapointsToAlarm;
                @Nullable
                private final Object $dimensions;
                @Nullable
                private final String $evaluateLowSampleCountPercentile;
                @Nullable
                private final String $extendedStatistic;
                @Nullable
                private final List<String> $insufficientDataActions;
                @Nullable
                private final String $metricName;
                @Nullable
                private final Object $metrics;
                @Nullable
                private final String $namespace;
                @Nullable
                private final List<String> $okActions;
                @Nullable
                private final Number $period;
                @Nullable
                private final String $statistic;
                @Nullable
                private final String $treatMissingData;
                @Nullable
                private final String $unit;
                {
                    this.$comparisonOperator = Objects.requireNonNull(_comparisonOperator, "comparisonOperator is required");
                    this.$evaluationPeriods = Objects.requireNonNull(_evaluationPeriods, "evaluationPeriods is required");
                    this.$threshold = Objects.requireNonNull(_threshold, "threshold is required");
                    this.$actionsEnabled = _actionsEnabled;
                    this.$alarmActions = _alarmActions;
                    this.$alarmDescription = _alarmDescription;
                    this.$alarmName = _alarmName;
                    this.$datapointsToAlarm = _datapointsToAlarm;
                    this.$dimensions = _dimensions;
                    this.$evaluateLowSampleCountPercentile = _evaluateLowSampleCountPercentile;
                    this.$extendedStatistic = _extendedStatistic;
                    this.$insufficientDataActions = _insufficientDataActions;
                    this.$metricName = _metricName;
                    this.$metrics = _metrics;
                    this.$namespace = _namespace;
                    this.$okActions = _okActions;
                    this.$period = _period;
                    this.$statistic = _statistic;
                    this.$treatMissingData = _treatMissingData;
                    this.$unit = _unit;
                }

                @Override
                public String getComparisonOperator() {
                    return this.$comparisonOperator;
                }

                @Override
                public Number getEvaluationPeriods() {
                    return this.$evaluationPeriods;
                }

                @Override
                public Number getThreshold() {
                    return this.$threshold;
                }

                @Override
                public Object getActionsEnabled() {
                    return this.$actionsEnabled;
                }

                @Override
                public List<String> getAlarmActions() {
                    return this.$alarmActions;
                }

                @Override
                public String getAlarmDescription() {
                    return this.$alarmDescription;
                }

                @Override
                public String getAlarmName() {
                    return this.$alarmName;
                }

                @Override
                public Number getDatapointsToAlarm() {
                    return this.$datapointsToAlarm;
                }

                @Override
                public Object getDimensions() {
                    return this.$dimensions;
                }

                @Override
                public String getEvaluateLowSampleCountPercentile() {
                    return this.$evaluateLowSampleCountPercentile;
                }

                @Override
                public String getExtendedStatistic() {
                    return this.$extendedStatistic;
                }

                @Override
                public List<String> getInsufficientDataActions() {
                    return this.$insufficientDataActions;
                }

                @Override
                public String getMetricName() {
                    return this.$metricName;
                }

                @Override
                public Object getMetrics() {
                    return this.$metrics;
                }

                @Override
                public String getNamespace() {
                    return this.$namespace;
                }

                @Override
                public List<String> getOkActions() {
                    return this.$okActions;
                }

                @Override
                public Number getPeriod() {
                    return this.$period;
                }

                @Override
                public String getStatistic() {
                    return this.$statistic;
                }

                @Override
                public String getTreatMissingData() {
                    return this.$treatMissingData;
                }

                @Override
                public String getUnit() {
                    return this.$unit;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("comparisonOperator", om.valueToTree((Object)this.getComparisonOperator()));
                    obj.set("evaluationPeriods", om.valueToTree((Object)this.getEvaluationPeriods()));
                    obj.set("threshold", om.valueToTree((Object)this.getThreshold()));
                    if (this.getActionsEnabled() != null) {
                        obj.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
                    }
                    if (this.getAlarmActions() != null) {
                        obj.set("alarmActions", om.valueToTree(this.getAlarmActions()));
                    }
                    if (this.getAlarmDescription() != null) {
                        obj.set("alarmDescription", om.valueToTree((Object)this.getAlarmDescription()));
                    }
                    if (this.getAlarmName() != null) {
                        obj.set("alarmName", om.valueToTree((Object)this.getAlarmName()));
                    }
                    if (this.getDatapointsToAlarm() != null) {
                        obj.set("datapointsToAlarm", om.valueToTree((Object)this.getDatapointsToAlarm()));
                    }
                    if (this.getDimensions() != null) {
                        obj.set("dimensions", om.valueToTree(this.getDimensions()));
                    }
                    if (this.getEvaluateLowSampleCountPercentile() != null) {
                        obj.set("evaluateLowSampleCountPercentile", om.valueToTree((Object)this.getEvaluateLowSampleCountPercentile()));
                    }
                    if (this.getExtendedStatistic() != null) {
                        obj.set("extendedStatistic", om.valueToTree((Object)this.getExtendedStatistic()));
                    }
                    if (this.getInsufficientDataActions() != null) {
                        obj.set("insufficientDataActions", om.valueToTree(this.getInsufficientDataActions()));
                    }
                    if (this.getMetricName() != null) {
                        obj.set("metricName", om.valueToTree((Object)this.getMetricName()));
                    }
                    if (this.getMetrics() != null) {
                        obj.set("metrics", om.valueToTree(this.getMetrics()));
                    }
                    if (this.getNamespace() != null) {
                        obj.set("namespace", om.valueToTree((Object)this.getNamespace()));
                    }
                    if (this.getOkActions() != null) {
                        obj.set("okActions", om.valueToTree(this.getOkActions()));
                    }
                    if (this.getPeriod() != null) {
                        obj.set("period", om.valueToTree((Object)this.getPeriod()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree((Object)this.getStatistic()));
                    }
                    if (this.getTreatMissingData() != null) {
                        obj.set("treatMissingData", om.valueToTree((Object)this.getTreatMissingData()));
                    }
                    if (this.getUnit() != null) {
                        obj.set("unit", om.valueToTree((Object)this.getUnit()));
                    }
                    return obj;
                }
            };
        }
    }
}

