/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.cloudwatch.Shading;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface HorizontalAnnotation
extends JsiiSerializable {
    public Number getValue();

    public String getColor();

    public Shading getFill();

    public String getLabel();

    public Boolean getVisible();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _value;
        @Nullable
        private String _color;
        @Nullable
        private Shading _fill;
        @Nullable
        private String _label;
        @Nullable
        private Boolean _visible;

        public Builder withValue(Number value) {
            this._value = Objects.requireNonNull(value, "value is required");
            return this;
        }

        public Builder withColor(@Nullable String value) {
            this._color = value;
            return this;
        }

        public Builder withFill(@Nullable Shading value) {
            this._fill = value;
            return this;
        }

        public Builder withLabel(@Nullable String value) {
            this._label = value;
            return this;
        }

        public Builder withVisible(@Nullable Boolean value) {
            this._visible = value;
            return this;
        }

        public HorizontalAnnotation build() {
            return new HorizontalAnnotation(){
                private final Number $value;
                @Nullable
                private final String $color;
                @Nullable
                private final Shading $fill;
                @Nullable
                private final String $label;
                @Nullable
                private final Boolean $visible;
                {
                    this.$value = Objects.requireNonNull(_value, "value is required");
                    this.$color = _color;
                    this.$fill = _fill;
                    this.$label = _label;
                    this.$visible = _visible;
                }

                @Override
                public Number getValue() {
                    return this.$value;
                }

                @Override
                public String getColor() {
                    return this.$color;
                }

                @Override
                public Shading getFill() {
                    return this.$fill;
                }

                @Override
                public String getLabel() {
                    return this.$label;
                }

                @Override
                public Boolean getVisible() {
                    return this.$visible;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("value", om.valueToTree((Object)this.getValue()));
                    if (this.getColor() != null) {
                        obj.set("color", om.valueToTree((Object)this.getColor()));
                    }
                    if (this.getFill() != null) {
                        obj.set("fill", om.valueToTree((Object)this.getFill()));
                    }
                    if (this.getLabel() != null) {
                        obj.set("label", om.valueToTree((Object)this.getLabel()));
                    }
                    if (this.getVisible() != null) {
                        obj.set("visible", om.valueToTree((Object)this.getVisible()));
                    }
                    return obj;
                }
            };
        }
    }
}

