/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.cloudwatch.Dimension;
import software.amazon.awscdk.services.cloudwatch.Statistic;
import software.amazon.awscdk.services.cloudwatch.Unit;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface MetricAlarmConfig
extends JsiiSerializable {
    public String getMetricName();

    public String getNamespace();

    public Number getPeriod();

    public List<Dimension> getDimensions();

    public String getExtendedStatistic();

    public Statistic getStatistic();

    public Unit getUnit();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _metricName;
        private String _namespace;
        private Number _period;
        @Nullable
        private List<Dimension> _dimensions;
        @Nullable
        private String _extendedStatistic;
        @Nullable
        private Statistic _statistic;
        @Nullable
        private Unit _unit;

        public Builder withMetricName(String value) {
            this._metricName = Objects.requireNonNull(value, "metricName is required");
            return this;
        }

        public Builder withNamespace(String value) {
            this._namespace = Objects.requireNonNull(value, "namespace is required");
            return this;
        }

        public Builder withPeriod(Number value) {
            this._period = Objects.requireNonNull(value, "period is required");
            return this;
        }

        public Builder withDimensions(@Nullable List<Dimension> value) {
            this._dimensions = value;
            return this;
        }

        public Builder withExtendedStatistic(@Nullable String value) {
            this._extendedStatistic = value;
            return this;
        }

        public Builder withStatistic(@Nullable Statistic value) {
            this._statistic = value;
            return this;
        }

        public Builder withUnit(@Nullable Unit value) {
            this._unit = value;
            return this;
        }

        public MetricAlarmConfig build() {
            return new MetricAlarmConfig(){
                private final String $metricName;
                private final String $namespace;
                private final Number $period;
                @Nullable
                private final List<Dimension> $dimensions;
                @Nullable
                private final String $extendedStatistic;
                @Nullable
                private final Statistic $statistic;
                @Nullable
                private final Unit $unit;
                {
                    this.$metricName = Objects.requireNonNull(_metricName, "metricName is required");
                    this.$namespace = Objects.requireNonNull(_namespace, "namespace is required");
                    this.$period = Objects.requireNonNull(_period, "period is required");
                    this.$dimensions = _dimensions;
                    this.$extendedStatistic = _extendedStatistic;
                    this.$statistic = _statistic;
                    this.$unit = _unit;
                }

                @Override
                public String getMetricName() {
                    return this.$metricName;
                }

                @Override
                public String getNamespace() {
                    return this.$namespace;
                }

                @Override
                public Number getPeriod() {
                    return this.$period;
                }

                @Override
                public List<Dimension> getDimensions() {
                    return this.$dimensions;
                }

                @Override
                public String getExtendedStatistic() {
                    return this.$extendedStatistic;
                }

                @Override
                public Statistic getStatistic() {
                    return this.$statistic;
                }

                @Override
                public Unit getUnit() {
                    return this.$unit;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("metricName", om.valueToTree((Object)this.getMetricName()));
                    obj.set("namespace", om.valueToTree((Object)this.getNamespace()));
                    obj.set("period", om.valueToTree((Object)this.getPeriod()));
                    if (this.getDimensions() != null) {
                        obj.set("dimensions", om.valueToTree(this.getDimensions()));
                    }
                    if (this.getExtendedStatistic() != null) {
                        obj.set("extendedStatistic", om.valueToTree((Object)this.getExtendedStatistic()));
                    }
                    if (this.getStatistic() != null) {
                        obj.set("statistic", om.valueToTree((Object)this.getStatistic()));
                    }
                    if (this.getUnit() != null) {
                        obj.set("unit", om.valueToTree((Object)this.getUnit()));
                    }
                    return obj;
                }
            };
        }
    }
}

