/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.$Module;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.MetricAlarmConfig;
import software.amazon.awscdk.services.cloudwatch.MetricConfig;
import software.amazon.awscdk.services.cloudwatch.MetricGraphConfig;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.cloudwatch.MetricProps;
import software.amazon.awscdk.services.cloudwatch.Unit;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.IConstruct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-cloudwatch.Metric")
public class Metric
extends JsiiObject
implements IMetric {
    protected Metric(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Metric(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Metric(@NotNull MetricProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static Grant grantPutMetricData(@NotNull IGrantable grantee) {
        return (Grant)JsiiObject.jsiiStaticCall(Metric.class, (String)"grantPutMetricData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public Metric attachTo(@NotNull IConstruct scope) {
        return (Metric)Kernel.call((Object)this, (String)"attachTo", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public Alarm createAlarm(@NotNull Construct scope, @NotNull String id, @NotNull CreateAlarmOptions props) {
        return (Alarm)Kernel.call((Object)this, (String)"createAlarm", (NativeType)NativeType.forClass(Alarm.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public MetricAlarmConfig toAlarmConfig() {
        return (MetricAlarmConfig)Kernel.call((Object)this, (String)"toAlarmConfig", (NativeType)NativeType.forClass(MetricAlarmConfig.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public MetricGraphConfig toGraphConfig() {
        return (MetricGraphConfig)Kernel.call((Object)this, (String)"toGraphConfig", (NativeType)NativeType.forClass(MetricGraphConfig.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public MetricConfig toMetricConfig() {
        return (MetricConfig)Kernel.call((Object)this, (String)"toMetricConfig", (NativeType)NativeType.forClass(MetricConfig.class), (Object[])new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)this, (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric with(@NotNull MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"with", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String getMetricName() {
        return (String)Kernel.get((Object)this, (String)"metricName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getNamespace() {
        return (String)Kernel.get((Object)this, (String)"namespace", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Duration getPeriod() {
        return (Duration)Kernel.get((Object)this, (String)"period", (NativeType)NativeType.forClass(Duration.class));
    }

    @NotNull
    public String getStatistic() {
        return (String)Kernel.get((Object)this, (String)"statistic", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getAccount() {
        return (String)Kernel.get((Object)this, (String)"account", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getColor() {
        return (String)Kernel.get((Object)this, (String)"color", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Map<String, Object> getDimensions() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"dimensions", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public String getLabel() {
        return (String)Kernel.get((Object)this, (String)"label", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getRegion() {
        return (String)Kernel.get((Object)this, (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Unit getUnit() {
        return (Unit)((Object)Kernel.get((Object)this, (String)"unit", (NativeType)NativeType.forClass(Unit.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Metric> {
        private final MetricProps.Builder props = new MetricProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder account(String account) {
            this.props.account(account);
            return this;
        }

        public Builder color(String color) {
            this.props.color(color);
            return this;
        }

        public Builder dimensions(Map<String, ? extends Object> dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder label(String label) {
            this.props.label(label);
            return this;
        }

        public Builder period(Duration period) {
            this.props.period(period);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder statistic(String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        public Builder unit(Unit unit) {
            this.props.unit(unit);
            return this;
        }

        public Builder metricName(String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        public Builder namespace(String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Metric build() {
            return new Metric(this.props.build());
        }
    }
}

