package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running x86-64 Linux.
 * <p>
 * This class has a bunch of public constants that represent the most popular images.
 * <p>
 * You can also specify a custom image using one of the static methods:
 * <p>
 * <ul>
 * <li>LinuxBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }])</li>
 * <li>LinuxBuildImage.fromEcrRepository(repo[, tag])</li>
 * <li>LinuxBuildImage.fromAsset(parent, id, props)</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Turn this on because the pipeline uses Docker image assets
 *         .dockerEnabledForSelfMutation(true)
 *         .build();
 * pipeline.addWave("MyWave", WaveOptions.builder()
 *         .post(List.of(
 *             CodeBuildStep.Builder.create("RunApproval")
 *                     .commands(List.of("command-from-image"))
 *                     .buildEnvironment(BuildEnvironment.builder()
 *                             // The user of a Docker image asset in the pipeline requires turning on
 *                             // 'dockerEnabledForSelfMutation'.
 *                             .buildImage(LinuxBuildImage.fromAsset(this, "Image", DockerImageAssetProps.builder()
 *                                     .directory("./docker-image")
 *                                     .build()))
 *                             .build())
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:42.852Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.LinuxBuildImage")
public class LinuxBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected LinuxBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_LINUX_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_ARM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_ARM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_ARM_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "AMAZON_LINUX_2_ARM_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_4_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_4_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        STANDARD_5_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "STANDARD_5_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_ANDROID_JAVA8_24_4_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_ANDROID_JAVA8_24_4_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_ANDROID_JAVA8_26_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_ANDROID_JAVA8_26_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_BASE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_DOCKER_17_09_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOCKER_17_09_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_DOCKER_18_09_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOCKER_18_09_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_DOTNET_CORE_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_DOTNET_CORE_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_DOTNET_CORE_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_DOTNET_CORE_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_GOLANG_1_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_GOLANG_1_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_GOLANG_1_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_GOLANG_1_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_NODEJS_10_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_10_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_NODEJS_10_14_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_10_14_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_NODEJS_6_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_6_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_NODEJS_8_11_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_NODEJS_8_11_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_OPEN_JDK_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_OPEN_JDK_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_OPEN_JDK_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_OPEN_JDK_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_OPEN_JDK_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_OPEN_JDK_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PHP_5_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PHP_5_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PHP_7_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PHP_7_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PHP_7_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PHP_7_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_2_7_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_2_7_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_3_3_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_3_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_3_4_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_4_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_3_5_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_5_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_3_6_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_6_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_PYTHON_3_7_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_PYTHON_3_7_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_RUBY_2_2_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_2_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_RUBY_2_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_RUBY_2_5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_5_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        UBUNTU_14_04_RUBY_2_5_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "UBUNTU_14_04_RUBY_2_5_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
    }

    /**
     * Uses an Docker image asset as a x86-64 Linux build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uses a Docker image provided by CodeBuild.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "aws/codebuild/standard:4.0";
     * </pre></blockquote>
     * <p>
     * @return A Docker image provided by CodeBuild.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
     * @param id The image identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromCodeBuildImageId(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromCodeBuildImageId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @return a x86-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @return a x86-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @return A x86-64 Linux build image from an ECR repository.
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     * @param tagOrDigest Image tag or digest (default "latest", digests must start with `sha256:`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest });
    }

    /**
     * @return A x86-64 Linux build image from an ECR repository.
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param _ This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment _) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(_, "_ is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_2;

    /**
     * The Amazon Linux 2 x86_64 standard image, version `3.0`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_3;

    /**
     * @deprecated Use LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_1_0 instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_ARM;

    /**
     * (deprecated) Image "aws/codebuild/amazonlinux2-aarch64-standard:2.0".
     * <p>
     * @deprecated Use LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_2_0 instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_ARM_2;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_1_0;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_2_0;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_3_0;

    /**
     * The `aws/codebuild/standard:4.0` build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_4_0;

    /**
     * The `aws/codebuild/standard:5.0` build image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage STANDARD_5_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_ANDROID_JAVA8_24_4_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_ANDROID_JAVA8_26_1_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_BASE;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_DOCKER_17_09_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_DOCKER_18_09_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_DOTNET_CORE_1_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_DOTNET_CORE_2_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_DOTNET_CORE_2_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_GOLANG_1_10;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_GOLANG_1_11;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_NODEJS_10_1_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_NODEJS_10_14_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_NODEJS_6_3_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_NODEJS_8_11_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_OPEN_JDK_11;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_OPEN_JDK_8;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_OPEN_JDK_9;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PHP_5_6;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PHP_7_0;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PHP_7_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_2_7_12;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_3_3_6;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_3_4_5;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_3_5_2;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_3_6_5;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_PYTHON_3_7_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_RUBY_2_2_5;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_RUBY_2_3_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_RUBY_2_5_1;

    /**
     * @deprecated Use {@link STANDARD_2_0} and specify runtime in buildspec runtime-versions section
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage UBUNTU_14_04_RUBY_2_5_3;

    /**
     * The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
    }

    /**
     * An optional ECR repository that the image is hosted in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }
}
