package software.amazon.awscdk.services.codebuild;

/**
 * The types of webhook event actions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISource gitHubSource = Source.gitHub(GitHubSourceProps.builder()
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .webhook(true) // optional, default: true if `webhookFilters` were provided, false otherwise
 *         .webhookTriggersBatchBuild(true) // optional, default is false
 *         .webhookFilters(List.of(FilterGroup.inEventOf(EventAction.PUSH).andBranchIs("master").andCommitMessageIs("the commit message")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:41.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.EventAction")
public enum EventAction {
    /**
     * A push (of a branch, or a tag) to the repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUSH,
    /**
     * Creating a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_CREATED,
    /**
     * Updating a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_UPDATED,
    /**
     * Merging a Pull Request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_MERGED,
    /**
     * Re-opening a previously closed Pull Request.
     * <p>
     * Note that this event is only supported for GitHub and GitHubEnterprise sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PULL_REQUEST_REOPENED,
}
