package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of an EC2/on-premise Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HalfAtATime`, `ServerDeploymentConfig.AllAtOnce`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:39.183Z")
public interface IServerDeploymentConfig extends software.amazon.jsii.JsiiSerializable {
    java.lang.String getDeploymentConfigArn();
    java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link IServerDeploymentConfig}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IServerDeploymentConfig}
     */
    final class Builder {
        private java.lang.String _deploymentConfigArn;
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of DeploymentConfigArn
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withDeploymentConfigArn(final java.lang.String value) {
            this._deploymentConfigArn = java.util.Objects.requireNonNull(value, "deploymentConfigArn is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfigName
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IServerDeploymentConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        public IServerDeploymentConfig build() {
            return new IServerDeploymentConfig() {
                private final java.lang.String $deploymentConfigArn = java.util.Objects.requireNonNull(_deploymentConfigArn, "deploymentConfigArn is required");
                private final java.lang.String $deploymentConfigName = java.util.Objects.requireNonNull(_deploymentConfigName, "deploymentConfigName is required");

                @Override
                public java.lang.String getDeploymentConfigArn() {
                    return this.$deploymentConfigArn;
                }

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public java.lang.String getDeploymentConfigArn() {
            return this.jsiiGet("deploymentConfigArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
