package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-11T18:05:39.197Z")
public interface ServerDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the Deployment Configuration.
     * @default a name will be auto-generated
     */
    java.lang.String getDeploymentConfigName();
    /**
     * The physical, human-readable name of the Deployment Configuration.
     * @default a name will be auto-generated
     */
    void setDeploymentConfigName(final java.lang.String value);
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostPercentage},
     * however one of this or {@link #minHealthyHostPercentage} is required.
     */
    java.lang.Number getMinHealthyHostCount();
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostPercentage},
     * however one of this or {@link #minHealthyHostPercentage} is required.
     */
    void setMinHealthyHostCount(final java.lang.Number value);
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostCount},
     * however one of this or {@link #minHealthyHostCount} is required.
     */
    java.lang.Number getMinHealthyHostPercentage();
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostCount},
     * however one of this or {@link #minHealthyHostCount} is required.
     */
    void setMinHealthyHostPercentage(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentConfigProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _deploymentConfigName;
        @javax.annotation.Nullable
        private java.lang.Number _minHealthyHostCount;
        @javax.annotation.Nullable
        private java.lang.Number _minHealthyHostPercentage;

        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        public Builder withDeploymentConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentConfigName = value;
            return this;
        }
        /**
         * Sets the value of MinHealthyHostCount
         * @param value The minimum healhty hosts threshold expressed as an absolute number.
If you've specified this value,
you can't specify {@link #minHealthyHostPercentage},
however one of this or {@link #minHealthyHostPercentage} is required.
         * @return {@code this}
         */
        public Builder withMinHealthyHostCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._minHealthyHostCount = value;
            return this;
        }
        /**
         * Sets the value of MinHealthyHostPercentage
         * @param value The minmum healhty hosts threshold expressed as a percentage of the fleet.
If you've specified this value,
you can't specify {@link #minHealthyHostCount},
however one of this or {@link #minHealthyHostCount} is required.
         * @return {@code this}
         */
        public Builder withMinHealthyHostPercentage(@javax.annotation.Nullable final java.lang.Number value) {
            this._minHealthyHostPercentage = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentConfigProps build() {
            return new ServerDeploymentConfigProps() {
                @javax.annotation.Nullable
                private java.lang.String $deploymentConfigName = _deploymentConfigName;
                @javax.annotation.Nullable
                private java.lang.Number $minHealthyHostCount = _minHealthyHostCount;
                @javax.annotation.Nullable
                private java.lang.Number $minHealthyHostPercentage = _minHealthyHostPercentage;

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                @Override
                public void setDeploymentConfigName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$deploymentConfigName = value;
                }

                @Override
                public java.lang.Number getMinHealthyHostCount() {
                    return this.$minHealthyHostCount;
                }

                @Override
                public void setMinHealthyHostCount(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$minHealthyHostCount = value;
                }

                @Override
                public java.lang.Number getMinHealthyHostPercentage() {
                    return this.$minHealthyHostPercentage;
                }

                @Override
                public void setMinHealthyHostPercentage(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$minHealthyHostPercentage = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * @default a name will be auto-generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * @default a name will be auto-generated
         */
        @Override
        public void setDeploymentConfigName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentConfigName", value);
        }

        /**
         * The minimum healhty hosts threshold expressed as an absolute number.
         * If you've specified this value,
         * you can't specify {@link #minHealthyHostPercentage},
         * however one of this or {@link #minHealthyHostPercentage} is required.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMinHealthyHostCount() {
            return this.jsiiGet("minHealthyHostCount", java.lang.Number.class);
        }

        /**
         * The minimum healhty hosts threshold expressed as an absolute number.
         * If you've specified this value,
         * you can't specify {@link #minHealthyHostPercentage},
         * however one of this or {@link #minHealthyHostPercentage} is required.
         */
        @Override
        public void setMinHealthyHostCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("minHealthyHostCount", value);
        }

        /**
         * The minmum healhty hosts threshold expressed as a percentage of the fleet.
         * If you've specified this value,
         * you can't specify {@link #minHealthyHostCount},
         * however one of this or {@link #minHealthyHostCount} is required.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getMinHealthyHostPercentage() {
            return this.jsiiGet("minHealthyHostPercentage", java.lang.Number.class);
        }

        /**
         * The minmum healhty hosts threshold expressed as a percentage of the fleet.
         * If you've specified this value,
         * you can't specify {@link #minHealthyHostCount},
         * however one of this or {@link #minHealthyHostCount} is required.
         */
        @Override
        public void setMinHealthyHostPercentage(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("minHealthyHostPercentage", value);
        }
    }
}
