/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.ServerApplicationRef;
import software.amazon.awscdk.services.codedeploy.api.ILoadBalancer;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.jsii.JsiiSerializable;

public interface ServerDeploymentGroupProps
extends JsiiSerializable {
    public ServerApplicationRef getApplication();

    public void setApplication(ServerApplicationRef var1);

    public List<AutoScalingGroup> getAutoScalingGroups();

    public void setAutoScalingGroups(List<AutoScalingGroup> var1);

    public IServerDeploymentConfig getDeploymentConfig();

    public void setDeploymentConfig(IServerDeploymentConfig var1);

    public String getDeploymentGroupName();

    public void setDeploymentGroupName(String var1);

    public Boolean getInstallAgent();

    public void setInstallAgent(Boolean var1);

    public ILoadBalancer getLoadBalancer();

    public void setLoadBalancer(ILoadBalancer var1);

    public Role getRole();

    public void setRole(Role var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ServerApplicationRef _application;
        @Nullable
        private List<AutoScalingGroup> _autoScalingGroups;
        @Nullable
        private IServerDeploymentConfig _deploymentConfig;
        @Nullable
        private String _deploymentGroupName;
        @Nullable
        private Boolean _installAgent;
        @Nullable
        private ILoadBalancer _loadBalancer;
        @Nullable
        private Role _role;

        public Builder withApplication(@Nullable ServerApplicationRef value) {
            this._application = value;
            return this;
        }

        public Builder withAutoScalingGroups(@Nullable List<AutoScalingGroup> value) {
            this._autoScalingGroups = value;
            return this;
        }

        public Builder withDeploymentConfig(@Nullable IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public Builder withDeploymentGroupName(@Nullable String value) {
            this._deploymentGroupName = value;
            return this;
        }

        public Builder withInstallAgent(@Nullable Boolean value) {
            this._installAgent = value;
            return this;
        }

        public Builder withLoadBalancer(@Nullable ILoadBalancer value) {
            this._loadBalancer = value;
            return this;
        }

        public Builder withRole(@Nullable Role value) {
            this._role = value;
            return this;
        }

        public ServerDeploymentGroupProps build() {
            return new ServerDeploymentGroupProps(){
                @Nullable
                private ServerApplicationRef $application;
                @Nullable
                private List<AutoScalingGroup> $autoScalingGroups;
                @Nullable
                private IServerDeploymentConfig $deploymentConfig;
                @Nullable
                private String $deploymentGroupName;
                @Nullable
                private Boolean $installAgent;
                @Nullable
                private ILoadBalancer $loadBalancer;
                @Nullable
                private Role $role;
                {
                    this.$application = _application;
                    this.$autoScalingGroups = _autoScalingGroups;
                    this.$deploymentConfig = _deploymentConfig;
                    this.$deploymentGroupName = _deploymentGroupName;
                    this.$installAgent = _installAgent;
                    this.$loadBalancer = _loadBalancer;
                    this.$role = _role;
                }

                @Override
                public ServerApplicationRef getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(@Nullable ServerApplicationRef value) {
                    this.$application = value;
                }

                @Override
                public List<AutoScalingGroup> getAutoScalingGroups() {
                    return this.$autoScalingGroups;
                }

                @Override
                public void setAutoScalingGroups(@Nullable List<AutoScalingGroup> value) {
                    this.$autoScalingGroups = value;
                }

                @Override
                public IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public void setDeploymentConfig(@Nullable IServerDeploymentConfig value) {
                    this.$deploymentConfig = value;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(@Nullable String value) {
                    this.$deploymentGroupName = value;
                }

                @Override
                public Boolean getInstallAgent() {
                    return this.$installAgent;
                }

                @Override
                public void setInstallAgent(@Nullable Boolean value) {
                    this.$installAgent = value;
                }

                @Override
                public ILoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public void setLoadBalancer(@Nullable ILoadBalancer value) {
                    this.$loadBalancer = value;
                }

                @Override
                public Role getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@Nullable Role value) {
                    this.$role = value;
                }
            };
        }
    }
}

