package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of the {@link PipelineDeployAction CodeDeploy deploy CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T21:22:15.487Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps, software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps {
    /**
     * The name of the CodeDeploy application to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    java.lang.String getApplicationName();
    /**
     * The name of the CodeDeploy application to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    void setApplicationName(final java.lang.String value);
    /**
     * The name of the CodeDeploy deployment group to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The name of the CodeDeploy deployment group to deploy to.
     * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * The source to use as input for deployment.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for deployment.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private java.lang.String _applicationName;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of ApplicationName
         * @param value The name of the CodeDeploy application to deploy to.
         * @return {@code this}
         */
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The name of the CodeDeploy deployment group to deploy to.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                private java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = _inputArtifact;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public void setApplicationName(final java.lang.String value) {
                    this.$applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(final java.lang.String value) {
                    this.$deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the CodeDeploy application to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * The name of the CodeDeploy application to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }

        /**
         * The name of the CodeDeploy deployment group to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The name of the CodeDeploy deployment group to deploy to.
         * @note this will most likely be changed to a proper CodeDeploy AWS Construct reference once that functionality has been implemented for CodeDeploy
         */
        @Override
        public void setDeploymentGroupName(final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", java.util.Objects.requireNonNull(value, "deploymentGroupName is required"));
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
