package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a reference to a CodeDeploy Application deploying to EC2/on-premise instances.
 * 
 * If you're managing the Application alongside the rest of your CDK resources,
 * use the {@link ServerApplication} class.
 * 
 * If you want to reference an already existing Application,
 * or one defined in a different CDK Stack,
 * use the {@link #import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T20:01:11.352Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerApplicationRef")
public abstract class ServerApplicationRef extends software.amazon.awscdk.Construct {
    protected ServerApplicationRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Import an Application defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     * @return a Construct representing a reference to an existing Application
     * @param parent the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced Application
     */
    public static software.amazon.awscdk.services.codedeploy.ServerApplicationRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.ServerApplicationRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class, "import", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    public software.amazon.awscdk.services.codedeploy.ServerApplicationRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.codedeploy.ServerApplicationRefProps.class);
    }

    public java.lang.String getApplicationArn() {
        return this.jsiiGet("applicationArn", java.lang.String.class);
    }

    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.ServerApplicationRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public java.lang.String getApplicationArn() {
            return this.jsiiGet("applicationArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }
    }
}
