package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Configuration.
 * @see ServerDeploymentConfigRef#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T20:01:11.358Z")
public interface ServerDeploymentConfigRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
     * that we are referencing.
     */
    java.lang.String getDeploymentConfigName();
    /**
     * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
     * that we are referencing.
     */
    void setDeploymentConfigName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentConfigRefProps}
     */
    final class Builder {
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentConfigRefProps build() {
            return new ServerDeploymentConfigRefProps() {
                private java.lang.String $deploymentConfigName = java.util.Objects.requireNonNull(_deploymentConfigName, "deploymentConfigName is required");

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                @Override
                public void setDeploymentConfigName(final java.lang.String value) {
                    this.$deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
         * that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
         * that we are referencing.
         */
        @Override
        public void setDeploymentConfigName(final java.lang.String value) {
            this.jsiiSet("deploymentConfigName", java.util.Objects.requireNonNull(value, "deploymentConfigName is required"));
        }
    }
}
