package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * If you're managing the Deployment Group alongside the rest of your CDK resources,
 * use the {@link ServerDeploymentGroup} class.
 * 
 * If you want to reference an already existing Deployment Group,
 * or one defined in a different CDK Stack,
 * use the {@link #import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-19T13:29:10.296Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupRef")
public abstract class ServerDeploymentGroupRef extends software.amazon.awscdk.Construct {
    protected ServerDeploymentGroupRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Import an EC2/on-premise Deployment Group defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     * @return a Construct representing a reference to an existing Deployment Group
     * @param parent the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced Deployment Group
     */
    public static software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef.class, "import", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Convenience method for creating a new {@link PipelineDeployAction}
     * and adding it to the given Stage.
     * @return the newly created {@link PipelineDeployAction} deploy Action
     * @param stage the Pipeline Stage to add the new Action to
     * @param name the name of the newly created Action
     * @param props the properties of the new Action
     */
    public software.amazon.awscdk.services.codedeploy.PipelineDeployAction addToPipeline(final software.amazon.awscdk.services.codepipeline.api.IStage stage, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps props) {
        return this.jsiiCall("addToPipeline", software.amazon.awscdk.services.codedeploy.PipelineDeployAction.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(stage, "stage is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Convenience method for creating a new {@link PipelineDeployAction}
     * and adding it to the given Stage.
     * @return the newly created {@link PipelineDeployAction} deploy Action
     * @param stage the Pipeline Stage to add the new Action to
     * @param name the name of the newly created Action
     */
    public software.amazon.awscdk.services.codedeploy.PipelineDeployAction addToPipeline(final software.amazon.awscdk.services.codepipeline.api.IStage stage, final java.lang.String name) {
        return this.jsiiCall("addToPipeline", software.amazon.awscdk.services.codedeploy.PipelineDeployAction.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(stage, "stage is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    public software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps.class);
    }

    public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
        return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
    }

    public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
    }

    public java.lang.String getDeploymentGroupArn() {
        return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
    }

    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    @javax.annotation.Nullable
    public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
        return this.jsiiGet("autoScalingGroups", java.util.List.class);
    }

    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
        }

        @Override
        public java.lang.String getDeploymentGroupArn() {
            return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.util.List.class);
        }

        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }
    }
}
