package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * @see ServerDeploymentGroupRef#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:44:59.589Z")
public interface ServerDeploymentGroupRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy EC2/on-premise Application
     * that this Deployment Group belongs to.
     */
    software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication();
    /**
     * The reference to the CodeDeploy EC2/on-premise Application
     * that this Deployment Group belongs to.
     */
    void setApplication(final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value);
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group
     * that we are referencing.
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group
     * that we are referencing.
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * The Deployment Configuration this Deployment Group uses.
     * @default ServerDeploymentConfig#OneAtATime
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * @default ServerDeploymentConfig#OneAtATime
     */
    void setDeploymentConfig(final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value);

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupRefProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.ServerApplicationRef _application;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig _deploymentConfig;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy EC2/on-premise Application
that this Deployment Group belongs to.
         * @return {@code this}
         */
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group
that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentGroupRefProps build() {
            return new ServerDeploymentGroupRefProps() {
                private software.amazon.awscdk.services.codedeploy.ServerApplicationRef $application = java.util.Objects.requireNonNull(_application, "application is required");
                private java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig $deploymentConfig = _deploymentConfig;

                @Override
                public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
                    this.$application = java.util.Objects.requireNonNull(value, "application is required");
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(final java.lang.String value) {
                    this.$deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
                    this.$deploymentConfig = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy EC2/on-premise Application
         * that this Deployment Group belongs to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.ServerApplicationRef getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ServerApplicationRef.class);
        }

        /**
         * The reference to the CodeDeploy EC2/on-premise Application
         * that this Deployment Group belongs to.
         */
        @Override
        public void setApplication(final software.amazon.awscdk.services.codedeploy.ServerApplicationRef value) {
            this.jsiiSet("application", java.util.Objects.requireNonNull(value, "application is required"));
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group
         * that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group
         * that we are referencing.
         */
        @Override
        public void setDeploymentGroupName(final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", java.util.Objects.requireNonNull(value, "deploymentGroupName is required"));
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * @default ServerDeploymentConfig#OneAtATime
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * @default ServerDeploymentConfig#OneAtATime
         */
        @Override
        public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this.jsiiSet("deploymentConfig", value);
        }
    }
}
