package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Application.
 * @see ServerApplicationRef#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:24:21.114Z")
public interface ServerApplicationRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Application we're referencing.
     * The Application must be in the same account and region as the root Stack.
     */
    java.lang.String getApplicationName();
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Application we're referencing.
     * The Application must be in the same account and region as the root Stack.
     */
    void setApplicationName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link ServerApplicationRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerApplicationRefProps}
     */
    final class Builder {
        private java.lang.String _applicationName;

        /**
         * Sets the value of ApplicationName
         * @param value The physical, human-readable name of the CodeDeploy EC2/on-premise Application we're referencing.
The Application must be in the same account and region as the root Stack.
         * @return {@code this}
         */
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerApplicationRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerApplicationRefProps build() {
            return new ServerApplicationRefProps() {
                private java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public void setApplicationName(final java.lang.String value) {
                    this.$applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerApplicationRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Application we're referencing.
         * The Application must be in the same account and region as the root Stack.
         */
        @Override
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Application we're referencing.
         * The Application must be in the same account and region as the root Stack.
         */
        @Override
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
    }
}
