package software.amazon.awscdk.services.codedeploy;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:52:38.221Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup extends software.amazon.awscdk.Resource {
    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::CodeDeploy::DeploymentGroup``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnDeploymentGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     */
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        java.lang.Object getAlarms();
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        void setAlarms(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        java.lang.Object getIgnorePollAlarmFailure();
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final java.lang.Boolean value);
        /**
         * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        void setIgnorePollAlarmFailure(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AlarmConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _alarms;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePollAlarmFailure;

            /**
             * Sets the value of Alarms
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Alarms
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmConfigurationProperty build() {
                return new AlarmConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $alarms = _alarms;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignorePollAlarmFailure = _ignorePollAlarmFailure;

                    @Override
                    public java.lang.Object getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public void setAlarms(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$alarms = value;
                    }

                    @Override
                    public void setAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$alarms = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getIgnorePollAlarmFailure() {
                        return this.$ignorePollAlarmFailure;
                    }

                    @Override
                    public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignorePollAlarmFailure = value;
                    }

                    @Override
                    public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ignorePollAlarmFailure = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAlarms() {
                return this.jsiiGet("alarms", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            public void setAlarms(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("alarms", value);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Alarms``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            public void setAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("alarms", value);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePollAlarmFailure() {
                return this.jsiiGet("ignorePollAlarmFailure", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }

            /**
             * ``CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            public void setIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignorePollAlarmFailure", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     */
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        java.lang.String getName();
        /**
         * ``CfnDeploymentGroup.AlarmProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        void setName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value ``CfnDeploymentGroup.AlarmProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmProperty build() {
                return new AlarmProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.AlarmProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     */
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        java.lang.Object getEvents();
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        void setEvents(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _events;

            /**
             * Sets the value of Enabled
             * @param value ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Events
             * @param value ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
             * @return {@code this}
             */
            public Builder withEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._events = value;
                return this;
            }
            /**
             * Sets the value of Events
             * @param value ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
             * @return {@code this}
             */
            public Builder withEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._events = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AutoRollbackConfigurationProperty build() {
                return new AutoRollbackConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $events = _events;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getEvents() {
                        return this.$events;
                    }

                    @Override
                    public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$events = value;
                    }

                    @Override
                    public void setEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$events = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEvents() {
                return this.jsiiGet("events", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            public void setEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("events", value);
            }

            /**
             * ``CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            public void setEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("events", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     */
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        java.lang.Object getRevision();
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.Revision``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        void setRevision(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty value);
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        java.lang.String getDescription();
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        java.lang.Object getIgnoreApplicationStopFailures();
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final java.lang.Boolean value);
        /**
         * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        void setIgnoreApplicationStopFailures(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link DeploymentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentProperty}
         */
        final class Builder {
            private java.lang.Object _revision;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _ignoreApplicationStopFailures;

            /**
             * Sets the value of Revision
             * @param value ``CfnDeploymentGroup.DeploymentProperty.Revision``
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.Token value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Revision
             * @param value ``CfnDeploymentGroup.DeploymentProperty.Revision``
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Description
             * @param value ``CfnDeploymentGroup.DeploymentProperty.Description``
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentProperty build() {
                return new DeploymentProperty() {
                    private java.lang.Object $revision = java.util.Objects.requireNonNull(_revision, "revision is required");
                    @javax.annotation.Nullable
                    private java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private java.lang.Object $ignoreApplicationStopFailures = _ignoreApplicationStopFailures;

                    @Override
                    public java.lang.Object getRevision() {
                        return this.$revision;
                    }

                    @Override
                    public void setRevision(final software.amazon.awscdk.Token value) {
                        this.$revision = java.util.Objects.requireNonNull(value, "revision is required");
                    }

                    @Override
                    public void setRevision(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty value) {
                        this.$revision = java.util.Objects.requireNonNull(value, "revision is required");
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                        this.$description = value;
                    }

                    @Override
                    public java.lang.Object getIgnoreApplicationStopFailures() {
                        return this.$ignoreApplicationStopFailures;
                    }

                    @Override
                    public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$ignoreApplicationStopFailures = value;
                    }

                    @Override
                    public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ignoreApplicationStopFailures = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public java.lang.Object getRevision() {
                return this.jsiiGet("revision", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public void setRevision(final software.amazon.awscdk.Token value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.Revision``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public void setRevision(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty value) {
                this.jsiiSet("revision", java.util.Objects.requireNonNull(value, "revision is required"));
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this.jsiiGet("ignoreApplicationStopFailures", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            public void setIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ignoreApplicationStopFailures", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     */
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        java.lang.String getDeploymentOption();
        /**
         * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        void setDeploymentOption(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        java.lang.String getDeploymentType();
        /**
         * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        void setDeploymentType(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link DeploymentStyleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentStyleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _deploymentOption;
            @javax.annotation.Nullable
            private java.lang.String _deploymentType;

            /**
             * Sets the value of DeploymentOption
             * @param value ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption``
             * @return {@code this}
             */
            public Builder withDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentOption = value;
                return this;
            }
            /**
             * Sets the value of DeploymentType
             * @param value ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType``
             * @return {@code this}
             */
            public Builder withDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentStyleProperty build() {
                return new DeploymentStyleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $deploymentOption = _deploymentOption;
                    @javax.annotation.Nullable
                    private java.lang.String $deploymentType = _deploymentType;

                    @Override
                    public java.lang.String getDeploymentOption() {
                        return this.$deploymentOption;
                    }

                    @Override
                    public void setDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deploymentOption = value;
                    }

                    @Override
                    public java.lang.String getDeploymentType() {
                        return this.$deploymentType;
                    }

                    @Override
                    public void setDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$deploymentType = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDeploymentOption() {
                return this.jsiiGet("deploymentOption", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            public void setDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentOption", value);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDeploymentType() {
                return this.jsiiGet("deploymentType", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            public void setDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("deploymentType", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html
     */
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
         */
        java.lang.String getKey();
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
         */
        java.lang.String getType();
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
         */
        void setType(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
         */
        java.lang.String getValue();
        /**
         * ``CfnDeploymentGroup.EC2TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
         */
        void setValue(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link EC2TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value ``CfnDeploymentGroup.EC2TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``CfnDeploymentGroup.EC2TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnDeploymentGroup.EC2TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagFilterProperty build() {
                return new EC2TagFilterProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$key = value;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                        this.$value = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html
     */
    public static interface EC2TagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         */
        java.lang.Object getEc2TagGroup();
        /**
         * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         */
        void setEc2TagGroup(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         */
        void setEc2TagGroup(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link EC2TagSetListObjectProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagSetListObjectProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _ec2TagGroup;

            /**
             * Sets the value of Ec2TagGroup
             * @param value ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
             * @return {@code this}
             */
            public Builder withEc2TagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ec2TagGroup = value;
                return this;
            }
            /**
             * Sets the value of Ec2TagGroup
             * @param value ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
             * @return {@code this}
             */
            public Builder withEc2TagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ec2TagGroup = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagSetListObjectProperty build() {
                return new EC2TagSetListObjectProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $ec2TagGroup = _ec2TagGroup;

                    @Override
                    public java.lang.Object getEc2TagGroup() {
                        return this.$ec2TagGroup;
                    }

                    @Override
                    public void setEc2TagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ec2TagGroup = value;
                    }

                    @Override
                    public void setEc2TagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$ec2TagGroup = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEc2TagGroup() {
                return this.jsiiGet("ec2TagGroup", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
             */
            @Override
            public void setEc2TagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ec2TagGroup", value);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
             */
            @Override
            public void setEc2TagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ec2TagGroup", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html
     */
    public static interface EC2TagSetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         */
        java.lang.Object getEc2TagSetList();
        /**
         * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         */
        void setEc2TagSetList(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         */
        void setEc2TagSetList(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link EC2TagSetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagSetProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _ec2TagSetList;

            /**
             * Sets the value of Ec2TagSetList
             * @param value ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
             * @return {@code this}
             */
            public Builder withEc2TagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ec2TagSetList = value;
                return this;
            }
            /**
             * Sets the value of Ec2TagSetList
             * @param value ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
             * @return {@code this}
             */
            public Builder withEc2TagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ec2TagSetList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagSetProperty build() {
                return new EC2TagSetProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $ec2TagSetList = _ec2TagSetList;

                    @Override
                    public java.lang.Object getEc2TagSetList() {
                        return this.$ec2TagSetList;
                    }

                    @Override
                    public void setEc2TagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$ec2TagSetList = value;
                    }

                    @Override
                    public void setEc2TagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$ec2TagSetList = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEc2TagSetList() {
                return this.jsiiGet("ec2TagSetList", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
             */
            @Override
            public void setEc2TagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("ec2TagSetList", value);
            }

            /**
             * ``CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
             */
            @Override
            public void setEc2TagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("ec2TagSetList", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     */
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        java.lang.String getName();
        /**
         * ``CfnDeploymentGroup.ELBInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        void setName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link ELBInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ELBInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value ``CfnDeploymentGroup.ELBInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ELBInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ELBInfoProperty build() {
                return new ELBInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.ELBInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.ELBInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     */
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        java.lang.String getCommitId();
        /**
         * ``CfnDeploymentGroup.GitHubLocationProperty.CommitId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        void setCommitId(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        java.lang.String getRepository();
        /**
         * ``CfnDeploymentGroup.GitHubLocationProperty.Repository``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        void setRepository(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link GitHubLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GitHubLocationProperty}
         */
        final class Builder {
            private java.lang.String _commitId;
            private java.lang.String _repository;

            /**
             * Sets the value of CommitId
             * @param value ``CfnDeploymentGroup.GitHubLocationProperty.CommitId``
             * @return {@code this}
             */
            public Builder withCommitId(final java.lang.String value) {
                this._commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                return this;
            }
            /**
             * Sets the value of Repository
             * @param value ``CfnDeploymentGroup.GitHubLocationProperty.Repository``
             * @return {@code this}
             */
            public Builder withRepository(final java.lang.String value) {
                this._repository = java.util.Objects.requireNonNull(value, "repository is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitHubLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GitHubLocationProperty build() {
                return new GitHubLocationProperty() {
                    private java.lang.String $commitId = java.util.Objects.requireNonNull(_commitId, "commitId is required");
                    private java.lang.String $repository = java.util.Objects.requireNonNull(_repository, "repository is required");

                    @Override
                    public java.lang.String getCommitId() {
                        return this.$commitId;
                    }

                    @Override
                    public void setCommitId(final java.lang.String value) {
                        this.$commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                    }

                    @Override
                    public java.lang.String getRepository() {
                        return this.$repository;
                    }

                    @Override
                    public void setRepository(final java.lang.String value) {
                        this.$repository = java.util.Objects.requireNonNull(value, "repository is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public java.lang.String getCommitId() {
                return this.jsiiGet("commitId", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.GitHubLocationProperty.CommitId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public void setCommitId(final java.lang.String value) {
                this.jsiiSet("commitId", java.util.Objects.requireNonNull(value, "commitId is required"));
            }

            /**
             * ``CfnDeploymentGroup.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public java.lang.String getRepository() {
                return this.jsiiGet("repository", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.GitHubLocationProperty.Repository``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public void setRepository(final java.lang.String value) {
                this.jsiiSet("repository", java.util.Objects.requireNonNull(value, "repository is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     */
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        java.lang.Object getElbInfoList();
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        void setElbInfoList(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        java.lang.Object getTargetGroupInfoList();
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        void setTargetGroupInfoList(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link LoadBalancerInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancerInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _elbInfoList;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupInfoList;

            /**
             * Sets the value of ElbInfoList
             * @param value ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of ElbInfoList
             * @param value ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._targetGroupInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._targetGroupInfoList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoadBalancerInfoProperty build() {
                return new LoadBalancerInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $elbInfoList = _elbInfoList;
                    @javax.annotation.Nullable
                    private java.lang.Object $targetGroupInfoList = _targetGroupInfoList;

                    @Override
                    public java.lang.Object getElbInfoList() {
                        return this.$elbInfoList;
                    }

                    @Override
                    public void setElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$elbInfoList = value;
                    }

                    @Override
                    public void setElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$elbInfoList = value;
                    }

                    @Override
                    public java.lang.Object getTargetGroupInfoList() {
                        return this.$targetGroupInfoList;
                    }

                    @Override
                    public void setTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$targetGroupInfoList = value;
                    }

                    @Override
                    public void setTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$targetGroupInfoList = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElbInfoList() {
                return this.jsiiGet("elbInfoList", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            public void setElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("elbInfoList", value);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            public void setElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("elbInfoList", value);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupInfoList() {
                return this.jsiiGet("targetGroupInfoList", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            public void setTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupInfoList", value);
            }

            /**
             * ``CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            public void setTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("targetGroupInfoList", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html
     */
    public static interface OnPremisesTagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         */
        java.lang.Object getOnPremisesTagGroup();
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         */
        void setOnPremisesTagGroup(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         */
        void setOnPremisesTagGroup(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetListObjectProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OnPremisesTagSetListObjectProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _onPremisesTagGroup;

            /**
             * Sets the value of OnPremisesTagGroup
             * @param value ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
             * @return {@code this}
             */
            public Builder withOnPremisesTagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onPremisesTagGroup = value;
                return this;
            }
            /**
             * Sets the value of OnPremisesTagGroup
             * @param value ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
             * @return {@code this}
             */
            public Builder withOnPremisesTagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._onPremisesTagGroup = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OnPremisesTagSetListObjectProperty build() {
                return new OnPremisesTagSetListObjectProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $onPremisesTagGroup = _onPremisesTagGroup;

                    @Override
                    public java.lang.Object getOnPremisesTagGroup() {
                        return this.$onPremisesTagGroup;
                    }

                    @Override
                    public void setOnPremisesTagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$onPremisesTagGroup = value;
                    }

                    @Override
                    public void setOnPremisesTagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$onPremisesTagGroup = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnPremisesTagGroup() {
                return this.jsiiGet("onPremisesTagGroup", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
             */
            @Override
            public void setOnPremisesTagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("onPremisesTagGroup", value);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
             */
            @Override
            public void setOnPremisesTagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("onPremisesTagGroup", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html
     */
    public static interface OnPremisesTagSetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         */
        java.lang.Object getOnPremisesTagSetList();
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         */
        void setOnPremisesTagSetList(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         */
        void setOnPremisesTagSetList(final java.util.List<java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OnPremisesTagSetProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _onPremisesTagSetList;

            /**
             * Sets the value of OnPremisesTagSetList
             * @param value ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
             * @return {@code this}
             */
            public Builder withOnPremisesTagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onPremisesTagSetList = value;
                return this;
            }
            /**
             * Sets the value of OnPremisesTagSetList
             * @param value ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
             * @return {@code this}
             */
            public Builder withOnPremisesTagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._onPremisesTagSetList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OnPremisesTagSetProperty build() {
                return new OnPremisesTagSetProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $onPremisesTagSetList = _onPremisesTagSetList;

                    @Override
                    public java.lang.Object getOnPremisesTagSetList() {
                        return this.$onPremisesTagSetList;
                    }

                    @Override
                    public void setOnPremisesTagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$onPremisesTagSetList = value;
                    }

                    @Override
                    public void setOnPremisesTagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$onPremisesTagSetList = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnPremisesTagSetList() {
                return this.jsiiGet("onPremisesTagSetList", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
             */
            @Override
            public void setOnPremisesTagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("onPremisesTagSetList", value);
            }

            /**
             * ``CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
             */
            @Override
            public void setOnPremisesTagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("onPremisesTagSetList", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     */
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        java.lang.Object getGitHubLocation();
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        void setGitHubLocation(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty value);
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        java.lang.String getRevisionType();
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.RevisionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        void setRevisionType(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        java.lang.Object getS3Location();
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        void setS3Location(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty value);

        /**
         * @return a {@link Builder} of {@link RevisionLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RevisionLocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _gitHubLocation;
            @javax.annotation.Nullable
            private java.lang.String _revisionType;
            @javax.annotation.Nullable
            private java.lang.Object _s3Location;

            /**
             * Sets the value of GitHubLocation
             * @param value ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of GitHubLocation
             * @param value ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of RevisionType
             * @param value ``CfnDeploymentGroup.RevisionLocationProperty.RevisionType``
             * @return {@code this}
             */
            public Builder withRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this._revisionType = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._s3Location = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty value) {
                this._s3Location = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevisionLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RevisionLocationProperty build() {
                return new RevisionLocationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $gitHubLocation = _gitHubLocation;
                    @javax.annotation.Nullable
                    private java.lang.String $revisionType = _revisionType;
                    @javax.annotation.Nullable
                    private java.lang.Object $s3Location = _s3Location;

                    @Override
                    public java.lang.Object getGitHubLocation() {
                        return this.$gitHubLocation;
                    }

                    @Override
                    public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$gitHubLocation = value;
                    }

                    @Override
                    public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty value) {
                        this.$gitHubLocation = value;
                    }

                    @Override
                    public java.lang.String getRevisionType() {
                        return this.$revisionType;
                    }

                    @Override
                    public void setRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$revisionType = value;
                    }

                    @Override
                    public java.lang.Object getS3Location() {
                        return this.$s3Location;
                    }

                    @Override
                    public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$s3Location = value;
                    }

                    @Override
                    public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty value) {
                        this.$s3Location = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGitHubLocation() {
                return this.jsiiGet("gitHubLocation", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("gitHubLocation", value);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            public void setGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty value) {
                this.jsiiSet("gitHubLocation", value);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRevisionType() {
                return this.jsiiGet("revisionType", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.RevisionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            public void setRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("revisionType", value);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getS3Location() {
                return this.jsiiGet("s3Location", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Location", value);
            }

            /**
             * ``CfnDeploymentGroup.RevisionLocationProperty.S3Location``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            public void setS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty value) {
                this.jsiiSet("s3Location", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        java.lang.String getBucket();
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        java.lang.String getKey();
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        java.lang.String getBundleType();
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.BundleType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        void setBundleType(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        java.lang.String getETag();
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        void setETag(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        java.lang.String getVersion();
        /**
         * ``CfnDeploymentGroup.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        void setVersion(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _bundleType;
            @javax.annotation.Nullable
            private java.lang.String _eTag;
            @javax.annotation.Nullable
            private java.lang.String _version;

            /**
             * Sets the value of Bucket
             * @param value ``CfnDeploymentGroup.S3LocationProperty.Bucket``
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value ``CfnDeploymentGroup.S3LocationProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of BundleType
             * @param value ``CfnDeploymentGroup.S3LocationProperty.BundleType``
             * @return {@code this}
             */
            public Builder withBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this._bundleType = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value ``CfnDeploymentGroup.S3LocationProperty.ETag``
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final java.lang.String value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``CfnDeploymentGroup.S3LocationProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    @javax.annotation.Nullable
                    private java.lang.String $bundleType = _bundleType;
                    @javax.annotation.Nullable
                    private java.lang.String $eTag = _eTag;
                    @javax.annotation.Nullable
                    private java.lang.String $version = _version;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public void setBucket(final java.lang.String value) {
                        this.$bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(final java.lang.String value) {
                        this.$key = java.util.Objects.requireNonNull(value, "key is required");
                    }

                    @Override
                    public java.lang.String getBundleType() {
                        return this.$bundleType;
                    }

                    @Override
                    public void setBundleType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$bundleType = value;
                    }

                    @Override
                    public java.lang.String getETag() {
                        return this.$eTag;
                    }

                    @Override
                    public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                        this.$eTag = value;
                    }

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                        this.$version = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public void setBucket(final java.lang.String value) {
                this.jsiiSet("bucket", java.util.Objects.requireNonNull(value, "bucket is required"));
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public void setKey(final java.lang.String value) {
                this.jsiiSet("key", java.util.Objects.requireNonNull(value, "key is required"));
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getBundleType() {
                return this.jsiiGet("bundleType", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.BundleType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            public void setBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bundleType", value);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getETag() {
                return this.jsiiGet("eTag", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("eTag", value);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
         */
        java.lang.String getKey();
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
         */
        java.lang.String getType();
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
         */
        void setType(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
         */
        java.lang.String getValue();
        /**
         * ``CfnDeploymentGroup.TagFilterProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
         */
        void setValue(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value ``CfnDeploymentGroup.TagFilterProperty.Key``
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``CfnDeploymentGroup.TagFilterProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``CfnDeploymentGroup.TagFilterProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                        this.$key = value;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                        this.$value = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
             */
            @Override
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TagFilterProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     */
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        java.lang.String getName();
        /**
         * ``CfnDeploymentGroup.TargetGroupInfoProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        void setName(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link TargetGroupInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value ``CfnDeploymentGroup.TargetGroupInfoProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupInfoProperty build() {
                return new TargetGroupInfoProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TargetGroupInfoProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     */
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        java.lang.Object getTriggerEvents();
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final software.amazon.awscdk.Token value);
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        void setTriggerEvents(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        java.lang.String getTriggerName();
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        void setTriggerName(final java.lang.String value);
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        java.lang.String getTriggerTargetArn();
        /**
         * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        void setTriggerTargetArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TriggerConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _triggerEvents;
            @javax.annotation.Nullable
            private java.lang.String _triggerName;
            @javax.annotation.Nullable
            private java.lang.String _triggerTargetArn;

            /**
             * Sets the value of TriggerEvents
             * @param value ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
             * @return {@code this}
             */
            public Builder withTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._triggerEvents = value;
                return this;
            }
            /**
             * Sets the value of TriggerEvents
             * @param value ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
             * @return {@code this}
             */
            public Builder withTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._triggerEvents = value;
                return this;
            }
            /**
             * Sets the value of TriggerName
             * @param value ``CfnDeploymentGroup.TriggerConfigProperty.TriggerName``
             * @return {@code this}
             */
            public Builder withTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerName = value;
                return this;
            }
            /**
             * Sets the value of TriggerTargetArn
             * @param value ``CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn``
             * @return {@code this}
             */
            public Builder withTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerTargetArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TriggerConfigProperty build() {
                return new TriggerConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $triggerEvents = _triggerEvents;
                    @javax.annotation.Nullable
                    private java.lang.String $triggerName = _triggerName;
                    @javax.annotation.Nullable
                    private java.lang.String $triggerTargetArn = _triggerTargetArn;

                    @Override
                    public java.lang.Object getTriggerEvents() {
                        return this.$triggerEvents;
                    }

                    @Override
                    public void setTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$triggerEvents = value;
                    }

                    @Override
                    public void setTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$triggerEvents = value;
                    }

                    @Override
                    public java.lang.String getTriggerName() {
                        return this.$triggerName;
                    }

                    @Override
                    public void setTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$triggerName = value;
                    }

                    @Override
                    public java.lang.String getTriggerTargetArn() {
                        return this.$triggerTargetArn;
                    }

                    @Override
                    public void setTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$triggerTargetArn = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TriggerConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTriggerEvents() {
                return this.jsiiGet("triggerEvents", java.lang.Object.class);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            public void setTriggerEvents(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("triggerEvents", value);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            public void setTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("triggerEvents", value);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTriggerName() {
                return this.jsiiGet("triggerName", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            public void setTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerName", value);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTriggerTargetArn() {
                return this.jsiiGet("triggerTargetArn", java.lang.String.class);
            }

            /**
             * ``CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            public void setTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("triggerTargetArn", value);
            }
        }
    }
}
