package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of the {@link PipelineDeployAction CodeDeploy deploy CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:52:38.246Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps, software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps {
    /**
     * The CodeDeploy Deployment Group to deploy to.
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup();
    /**
     * The CodeDeploy Deployment Group to deploy to.
     */
    void setDeploymentGroup(final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup value);

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup _deploymentGroup;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of DeploymentGroup
         * @param value The CodeDeploy Deployment Group to deploy to.
         * @return {@code this}
         */
        public Builder withDeploymentGroup(final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup value) {
            this._deploymentGroup = java.util.Objects.requireNonNull(value, "deploymentGroup is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup $deploymentGroup = java.util.Objects.requireNonNull(_deploymentGroup, "deploymentGroup is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = _inputArtifact;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup() {
                    return this.$deploymentGroup;
                }

                @Override
                public void setDeploymentGroup(final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup value) {
                    this.$deploymentGroup = java.util.Objects.requireNonNull(value, "deploymentGroup is required");
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CodeDeploy Deployment Group to deploy to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup() {
            return this.jsiiGet("deploymentGroup", software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup.class);
        }

        /**
         * The CodeDeploy Deployment Group to deploy to.
         */
        @Override
        public void setDeploymentGroup(final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup value) {
            this.jsiiSet("deploymentGroup", java.util.Objects.requireNonNull(value, "deploymentGroup is required"));
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
