package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * If you're managing the Deployment Group alongside the rest of your CDK resources,
 * use the {@link ServerDeploymentGroup} class.
 * 
 * If you want to reference an already existing Deployment Group,
 * or one defined in a different CDK Stack,
 * use the {@link #import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:52:38.251Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupBase")
public abstract class ServerDeploymentGroupBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup {
    protected ServerDeploymentGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Convenience method for creating a new {@link PipelineDeployAction}
     * and adding it to the given Stage.
     * @return the newly created {@link PipelineDeployAction} deploy Action
     * @param stage the Pipeline Stage to add the new Action to
     * @param name the name of the newly created Action
     * @param props the properties of the new Action
     */
    public software.amazon.awscdk.services.codedeploy.PipelineDeployAction addToPipeline(final software.amazon.awscdk.services.codepipeline.api.IStage stage, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps props) {
        return this.jsiiCall("addToPipeline", software.amazon.awscdk.services.codedeploy.PipelineDeployAction.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(stage, "stage is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Convenience method for creating a new {@link PipelineDeployAction}
     * and adding it to the given Stage.
     * @return the newly created {@link PipelineDeployAction} deploy Action
     * @param stage the Pipeline Stage to add the new Action to
     * @param name the name of the newly created Action
     */
    public software.amazon.awscdk.services.codedeploy.PipelineDeployAction addToPipeline(final software.amazon.awscdk.services.codepipeline.api.IStage stage, final java.lang.String name) {
        return this.jsiiCall("addToPipeline", software.amazon.awscdk.services.codedeploy.PipelineDeployAction.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(stage, "stage is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    public abstract software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps export();

    @Override
    public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
        return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
    }

    @Override
    public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
    }

    @Override
    public java.lang.String getDeploymentGroupArn() {
        return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
    }

    @Override
    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    @Override
    @javax.annotation.Nullable
    public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
        return this.jsiiGet("autoScalingGroups", java.util.List.class);
    }

    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        @Override
        public java.lang.String getDeploymentGroupArn() {
            return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.util.List.class);
        }

        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps.class);
        }
    }
}
