package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link ServerDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:57:10.205Z")
public interface ServerDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * @default []
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms();
    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * @default []
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    void setAlarms(final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value);
    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
     * If you don't provide one, a new Application will be created.
     */
    software.amazon.awscdk.services.codedeploy.IServerApplication getApplication();
    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
     * If you don't provide one, a new Application will be created.
     */
    void setApplication(final software.amazon.awscdk.services.codedeploy.IServerApplication value);
    /**
     * The auto-rollback configuration for this Deployment Group.
     */
    software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback();
    /**
     * The auto-rollback configuration for this Deployment Group.
     */
    void setAutoRollback(final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value);
    /**
     * The auto-scaling groups belonging to this Deployment Group.
     * 
     * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
     * @default []
     */
    java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups();
    /**
     * The auto-scaling groups belonging to this Deployment Group.
     * 
     * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
     * @default []
     */
    void setAutoScalingGroups(final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> value);
    /**
     * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
     * @default ServerDeploymentConfig#OneAtATime
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig();
    /**
     * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
     * @default ServerDeploymentConfig#OneAtATime
     */
    void setDeploymentConfig(final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value);
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * @default no additional EC2 instances will be added to the Deployment Group
     */
    software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags();
    /**
     * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * @default no additional EC2 instances will be added to the Deployment Group
     */
    void setEc2InstanceTags(final software.amazon.awscdk.services.codedeploy.InstanceTagSet value);
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * @default false
     */
    java.lang.Boolean getIgnorePollAlarmsFailure();
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * @default false
     */
    void setIgnorePollAlarmsFailure(final java.lang.Boolean value);
    /**
     * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property,
     * you can set this property to add User Data that installs the CodeDeploy agent on the instances.
     * @default true
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
     */
    java.lang.Boolean getInstallAgent();
    /**
     * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property,
     * you can set this property to add User Data that installs the CodeDeploy agent on the instances.
     * @default true
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
     */
    void setInstallAgent(final java.lang.Boolean value);
    /**
     * The load balancer to place in front of this Deployment Group.
     * Can be either a classic Elastic Load Balancer,
     * or an Application Load Balancer / Network Load Balancer Target Group.
     * @default the Deployment Group will not have a load balancer defined
     */
    software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer();
    /**
     * The load balancer to place in front of this Deployment Group.
     * Can be either a classic Elastic Load Balancer,
     * or an Application Load Balancer / Network Load Balancer Target Group.
     * @default the Deployment Group will not have a load balancer defined
     */
    void setLoadBalancer(final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer value);
    /**
     * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * @default no additional on-premise instances will be added to the Deployment Group
     */
    software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags();
    /**
     * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * @default no additional on-premise instances will be added to the Deployment Group
     */
    void setOnPremiseInstanceTags(final software.amazon.awscdk.services.codedeploy.InstanceTagSet value);
    /**
     * The service Role of this Deployment Group.
     * If you don't provide one, a new Role will be created.
     */
    software.amazon.awscdk.services.iam.Role getRole();
    /**
     * The service Role of this Deployment Group.
     * If you don't provide one, a new Role will be created.
     */
    void setRole(final software.amazon.awscdk.services.iam.Role value);

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> _alarms;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerApplication _application;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig _autoRollback;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> _autoScalingGroups;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig _deploymentConfig;
        @javax.annotation.Nullable
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet _ec2InstanceTags;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePollAlarmsFailure;
        @javax.annotation.Nullable
        private java.lang.Boolean _installAgent;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.api.ILoadBalancer _loadBalancer;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet _onPremiseInstanceTags;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.Role _role;

        /**
         * Sets the value of Alarms
         * @param value The CloudWatch alarms associated with this Deployment Group.
CodeDeploy will stop (and optionally roll back)
a deployment if during it any of the alarms trigger.

Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @return {@code this}
         */
        public Builder withAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
            this._alarms = value;
            return this;
        }
        /**
         * Sets the value of Application
         * @param value The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
If you don't provide one, a new Application will be created.
         * @return {@code this}
         */
        public Builder withApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
            this._application = value;
            return this;
        }
        /**
         * Sets the value of AutoRollback
         * @param value The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        public Builder withAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }
        /**
         * Sets the value of AutoScalingGroups
         * @param value The auto-scaling groups belonging to this Deployment Group.

Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
         * @return {@code this}
         */
        public Builder withAutoScalingGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> value) {
            this._autoScalingGroups = value;
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentGroupName = value;
            return this;
        }
        /**
         * Sets the value of Ec2InstanceTags
         * @param value All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        public Builder withEc2InstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this._ec2InstanceTags = value;
            return this;
        }
        /**
         * Sets the value of IgnorePollAlarmsFailure
         * @param value Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        public Builder withIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }
        /**
         * Sets the value of InstallAgent
         * @param value If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property,
you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * @return {@code this}
         */
        public Builder withInstallAgent(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._installAgent = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancer
         * @param value The load balancer to place in front of this Deployment Group.
Can be either a classic Elastic Load Balancer,
or an Application Load Balancer / Network Load Balancer Target Group.
         * @return {@code this}
         */
        public Builder withLoadBalancer(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer value) {
            this._loadBalancer = value;
            return this;
        }
        /**
         * Sets the value of OnPremiseInstanceTags
         * @param value All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        public Builder withOnPremiseInstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this._onPremiseInstanceTags = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The service Role of this Deployment Group.
If you don't provide one, a new Role will be created.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this._role = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentGroupProps build() {
            return new ServerDeploymentGroupProps() {
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> $alarms = _alarms;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.IServerApplication $application = _application;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig $autoRollback = _autoRollback;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> $autoScalingGroups = _autoScalingGroups;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig $deploymentConfig = _deploymentConfig;
                @javax.annotation.Nullable
                private java.lang.String $deploymentGroupName = _deploymentGroupName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.InstanceTagSet $ec2InstanceTags = _ec2InstanceTags;
                @javax.annotation.Nullable
                private java.lang.Boolean $ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                @javax.annotation.Nullable
                private java.lang.Boolean $installAgent = _installAgent;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.api.ILoadBalancer $loadBalancer = _loadBalancer;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.InstanceTagSet $onPremiseInstanceTags = _onPremiseInstanceTags;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.iam.Role $role = _role;

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public void setAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
                    this.$alarms = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
                    this.$application = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public void setAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
                    this.$autoRollback = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
                    return this.$autoScalingGroups;
                }

                @Override
                public void setAutoScalingGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> value) {
                    this.$autoScalingGroups = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
                    this.$deploymentConfig = value;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$deploymentGroupName = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
                    return this.$ec2InstanceTags;
                }

                @Override
                public void setEc2InstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
                    this.$ec2InstanceTags = value;
                }

                @Override
                public java.lang.Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public void setIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$ignorePollAlarmsFailure = value;
                }

                @Override
                public java.lang.Boolean getInstallAgent() {
                    return this.$installAgent;
                }

                @Override
                public void setInstallAgent(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$installAgent = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public void setLoadBalancer(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer value) {
                    this.$loadBalancer = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
                    return this.$onPremiseInstanceTags;
                }

                @Override
                public void setOnPremiseInstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
                    this.$onPremiseInstanceTags = value;
                }

                @Override
                public software.amazon.awscdk.services.iam.Role getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
                    this.$role = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @default []
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
            return this.jsiiGet("alarms", java.util.List.class);
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @default []
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        public void setAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
            this.jsiiSet("alarms", value);
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * If you don't provide one, a new Application will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to.
         * If you don't provide one, a new Application will be created.
         */
        @Override
        public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
            this.jsiiSet("application", value);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.jsiiGet("autoRollback", software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         */
        @Override
        public void setAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this.jsiiSet("autoRollback", value);
        }

        /**
         * The auto-scaling groups belonging to this Deployment Group.
         * 
         * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
         * @default []
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.util.List.class);
        }

        /**
         * The auto-scaling groups belonging to this Deployment Group.
         * 
         * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
         * @default []
         */
        @Override
        public void setAutoScalingGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> value) {
            this.jsiiSet("autoScalingGroups", value);
        }

        /**
         * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * @default ServerDeploymentConfig#OneAtATime
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * @default ServerDeploymentConfig#OneAtATime
         */
        @Override
        public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this.jsiiSet("deploymentConfig", value);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", value);
        }

        /**
         * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @default no additional EC2 instances will be added to the Deployment Group
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
            return this.jsiiGet("ec2InstanceTags", software.amazon.awscdk.services.codedeploy.InstanceTagSet.class);
        }

        /**
         * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @default no additional EC2 instances will be added to the Deployment Group
         */
        @Override
        public void setEc2InstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this.jsiiSet("ec2InstanceTags", value);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.jsiiGet("ignorePollAlarmsFailure", java.lang.Boolean.class);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @default false
         */
        @Override
        public void setIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("ignorePollAlarmsFailure", value);
        }

        /**
         * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property,
         * you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * @default true
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInstallAgent() {
            return this.jsiiGet("installAgent", java.lang.Boolean.class);
        }

        /**
         * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property,
         * you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * @default true
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
         */
        @Override
        public void setInstallAgent(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("installAgent", value);
        }

        /**
         * The load balancer to place in front of this Deployment Group.
         * Can be either a classic Elastic Load Balancer,
         * or an Application Load Balancer / Network Load Balancer Target Group.
         * @default the Deployment Group will not have a load balancer defined
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer() {
            return this.jsiiGet("loadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancer.class);
        }

        /**
         * The load balancer to place in front of this Deployment Group.
         * Can be either a classic Elastic Load Balancer,
         * or an Application Load Balancer / Network Load Balancer Target Group.
         * @default the Deployment Group will not have a load balancer defined
         */
        @Override
        public void setLoadBalancer(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer value) {
            this.jsiiSet("loadBalancer", value);
        }

        /**
         * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @default no additional on-premise instances will be added to the Deployment Group
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
            return this.jsiiGet("onPremiseInstanceTags", software.amazon.awscdk.services.codedeploy.InstanceTagSet.class);
        }

        /**
         * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @default no additional on-premise instances will be added to the Deployment Group
         */
        @Override
        public void setOnPremiseInstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this.jsiiSet("onPremiseInstanceTags", value);
        }

        /**
         * The service Role of this Deployment Group.
         * If you don't provide one, a new Role will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * The service Role of this Deployment Group.
         * If you don't provide one, a new Role will be created.
         */
        @Override
        public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this.jsiiSet("role", value);
        }
    }
}
