package software.amazon.awscdk.services.codedeploy;

/**
 * Common properties for creating a {@link PipelineDeployAction},
 * either directly, through its constructor,
 * or through {@link IServerDeploymentGroup#addToPipeline}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:17:38.831Z")
public interface CommonPipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The source to use as input for deployment.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for deployment.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);

    /**
     * @return a {@link Builder} of {@link CommonPipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineDeployActionProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineDeployActionProps build() {
            return new CommonPipelineDeployActionProps() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = _inputArtifact;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for deployment.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }
    }
}
