package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of a Lambda Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link LambdaDeploymentConfig} class
 * (`LambdaDeploymentConfig.AllAtOnce`, `LambdaDeploymentConfig.Canary10Percent30Minutes`, etc.).
 * 
 * Note: CloudFormation does not currently support creating custom lambda configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {@link LambdaDeploymentConfig#import}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:17:38.833Z")
public interface ILambdaDeploymentConfig extends software.amazon.jsii.JsiiSerializable {
    java.lang.String getDeploymentConfigName();
    java.lang.String deploymentConfigArn(final software.amazon.awscdk.IConstruct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        @Override
        public java.lang.String deploymentConfigArn(final software.amazon.awscdk.IConstruct scope) {
            return this.jsiiCall("deploymentConfigArn", java.lang.String.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")).toArray());
        }
    }
}
