package software.amazon.awscdk.services.codedeploy;

/**
 * The configuration for automatically rolling back deployments in a given Deployment Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T17:02:16.164Z")
public interface AutoRollbackConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to automatically roll back a deployment during which one of the configured
     * CloudWatch alarms for this Deployment Group went off.
     * @default true if you've provided any Alarms with the `alarms` property, false otherwise
     */
    java.lang.Boolean getDeploymentInAlarm();
    /**
     * Whether to automatically roll back a deployment during which one of the configured
     * CloudWatch alarms for this Deployment Group went off.
     * @default true if you've provided any Alarms with the `alarms` property, false otherwise
     */
    void setDeploymentInAlarm(final java.lang.Boolean value);
    /**
     * Whether to automatically roll back a deployment that fails.
     * @default true
     */
    java.lang.Boolean getFailedDeployment();
    /**
     * Whether to automatically roll back a deployment that fails.
     * @default true
     */
    void setFailedDeployment(final java.lang.Boolean value);
    /**
     * Whether to automatically roll back a deployment that was manually stopped.
     * @default false
     */
    java.lang.Boolean getStoppedDeployment();
    /**
     * Whether to automatically roll back a deployment that was manually stopped.
     * @default false
     */
    void setStoppedDeployment(final java.lang.Boolean value);

    /**
     * @return a {@link Builder} of {@link AutoRollbackConfig}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AutoRollbackConfig}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _deploymentInAlarm;
        @javax.annotation.Nullable
        private java.lang.Boolean _failedDeployment;
        @javax.annotation.Nullable
        private java.lang.Boolean _stoppedDeployment;

        /**
         * Sets the value of DeploymentInAlarm
         * @param value Whether to automatically roll back a deployment during which one of the configured
CloudWatch alarms for this Deployment Group went off.
         * @return {@code this}
         */
        public Builder withDeploymentInAlarm(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deploymentInAlarm = value;
            return this;
        }
        /**
         * Sets the value of FailedDeployment
         * @param value Whether to automatically roll back a deployment that fails.
         * @return {@code this}
         */
        public Builder withFailedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._failedDeployment = value;
            return this;
        }
        /**
         * Sets the value of StoppedDeployment
         * @param value Whether to automatically roll back a deployment that was manually stopped.
         * @return {@code this}
         */
        public Builder withStoppedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._stoppedDeployment = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoRollbackConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AutoRollbackConfig build() {
            return new AutoRollbackConfig() {
                @javax.annotation.Nullable
                private java.lang.Boolean $deploymentInAlarm = _deploymentInAlarm;
                @javax.annotation.Nullable
                private java.lang.Boolean $failedDeployment = _failedDeployment;
                @javax.annotation.Nullable
                private java.lang.Boolean $stoppedDeployment = _stoppedDeployment;

                @Override
                public java.lang.Boolean getDeploymentInAlarm() {
                    return this.$deploymentInAlarm;
                }

                @Override
                public void setDeploymentInAlarm(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$deploymentInAlarm = value;
                }

                @Override
                public java.lang.Boolean getFailedDeployment() {
                    return this.$failedDeployment;
                }

                @Override
                public void setFailedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$failedDeployment = value;
                }

                @Override
                public java.lang.Boolean getStoppedDeployment() {
                    return this.$stoppedDeployment;
                }

                @Override
                public void setStoppedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$stoppedDeployment = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.AutoRollbackConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to automatically roll back a deployment during which one of the configured
         * CloudWatch alarms for this Deployment Group went off.
         * @default true if you've provided any Alarms with the `alarms` property, false otherwise
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeploymentInAlarm() {
            return this.jsiiGet("deploymentInAlarm", java.lang.Boolean.class);
        }

        /**
         * Whether to automatically roll back a deployment during which one of the configured
         * CloudWatch alarms for this Deployment Group went off.
         * @default true if you've provided any Alarms with the `alarms` property, false otherwise
         */
        @Override
        public void setDeploymentInAlarm(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("deploymentInAlarm", value);
        }

        /**
         * Whether to automatically roll back a deployment that fails.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getFailedDeployment() {
            return this.jsiiGet("failedDeployment", java.lang.Boolean.class);
        }

        /**
         * Whether to automatically roll back a deployment that fails.
         * @default true
         */
        @Override
        public void setFailedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("failedDeployment", value);
        }

        /**
         * Whether to automatically roll back a deployment that was manually stopped.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getStoppedDeployment() {
            return this.jsiiGet("stoppedDeployment", java.lang.Boolean.class);
        }

        /**
         * Whether to automatically roll back a deployment that was manually stopped.
         * @default false
         */
        @Override
        public void setStoppedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("stoppedDeployment", value);
        }
    }
}
