/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.LambdaApplication;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.lambda.Alias;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaDeploymentGroupProps
extends JsiiSerializable {
    public Alias getAlias();

    public void setAlias(Alias var1);

    public List<Alarm> getAlarms();

    public void setAlarms(List<Alarm> var1);

    public LambdaApplication getApplication();

    public void setApplication(LambdaApplication var1);

    public AutoRollbackConfig getAutoRollback();

    public void setAutoRollback(AutoRollbackConfig var1);

    public ILambdaDeploymentConfig getDeploymentConfig();

    public void setDeploymentConfig(ILambdaDeploymentConfig var1);

    public String getDeploymentGroupName();

    public void setDeploymentGroupName(String var1);

    public Boolean getIgnorePollAlarmsFailure();

    public void setIgnorePollAlarmsFailure(Boolean var1);

    public IFunction getPostHook();

    public void setPostHook(IFunction var1);

    public IFunction getPreHook();

    public void setPreHook(IFunction var1);

    public Role getRole();

    public void setRole(Role var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Alias _alias;
        @Nullable
        private List<Alarm> _alarms;
        @Nullable
        private LambdaApplication _application;
        @Nullable
        private AutoRollbackConfig _autoRollback;
        @Nullable
        private ILambdaDeploymentConfig _deploymentConfig;
        @Nullable
        private String _deploymentGroupName;
        @Nullable
        private Boolean _ignorePollAlarmsFailure;
        @Nullable
        private IFunction _postHook;
        @Nullable
        private IFunction _preHook;
        @Nullable
        private Role _role;

        public Builder withAlias(Alias value) {
            this._alias = Objects.requireNonNull(value, "alias is required");
            return this;
        }

        public Builder withAlarms(@Nullable List<Alarm> value) {
            this._alarms = value;
            return this;
        }

        public Builder withApplication(@Nullable LambdaApplication value) {
            this._application = value;
            return this;
        }

        public Builder withAutoRollback(@Nullable AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }

        public Builder withDeploymentConfig(@Nullable ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public Builder withDeploymentGroupName(@Nullable String value) {
            this._deploymentGroupName = value;
            return this;
        }

        public Builder withIgnorePollAlarmsFailure(@Nullable Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }

        public Builder withPostHook(@Nullable IFunction value) {
            this._postHook = value;
            return this;
        }

        public Builder withPreHook(@Nullable IFunction value) {
            this._preHook = value;
            return this;
        }

        public Builder withRole(@Nullable Role value) {
            this._role = value;
            return this;
        }

        public LambdaDeploymentGroupProps build() {
            return new LambdaDeploymentGroupProps(){
                private Alias $alias;
                @Nullable
                private List<Alarm> $alarms;
                @Nullable
                private LambdaApplication $application;
                @Nullable
                private AutoRollbackConfig $autoRollback;
                @Nullable
                private ILambdaDeploymentConfig $deploymentConfig;
                @Nullable
                private String $deploymentGroupName;
                @Nullable
                private Boolean $ignorePollAlarmsFailure;
                @Nullable
                private IFunction $postHook;
                @Nullable
                private IFunction $preHook;
                @Nullable
                private Role $role;
                {
                    this.$alias = Objects.requireNonNull(_alias, "alias is required");
                    this.$alarms = _alarms;
                    this.$application = _application;
                    this.$autoRollback = _autoRollback;
                    this.$deploymentConfig = _deploymentConfig;
                    this.$deploymentGroupName = _deploymentGroupName;
                    this.$ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                    this.$postHook = _postHook;
                    this.$preHook = _preHook;
                    this.$role = _role;
                }

                @Override
                public Alias getAlias() {
                    return this.$alias;
                }

                @Override
                public void setAlias(Alias value) {
                    this.$alias = Objects.requireNonNull(value, "alias is required");
                }

                @Override
                public List<Alarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public void setAlarms(@Nullable List<Alarm> value) {
                    this.$alarms = value;
                }

                @Override
                public LambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(@Nullable LambdaApplication value) {
                    this.$application = value;
                }

                @Override
                public AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public void setAutoRollback(@Nullable AutoRollbackConfig value) {
                    this.$autoRollback = value;
                }

                @Override
                public ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public void setDeploymentConfig(@Nullable ILambdaDeploymentConfig value) {
                    this.$deploymentConfig = value;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(@Nullable String value) {
                    this.$deploymentGroupName = value;
                }

                @Override
                public Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public void setIgnorePollAlarmsFailure(@Nullable Boolean value) {
                    this.$ignorePollAlarmsFailure = value;
                }

                @Override
                public IFunction getPostHook() {
                    return this.$postHook;
                }

                @Override
                public void setPostHook(@Nullable IFunction value) {
                    this.$postHook = value;
                }

                @Override
                public IFunction getPreHook() {
                    return this.$preHook;
                }

                @Override
                public void setPreHook(@Nullable IFunction value) {
                    this.$preHook = value;
                }

                @Override
                public Role getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@Nullable Role value) {
                    this.$role = value;
                }
            };
        }
    }
}

