package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link LambdaDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:14:18.265Z")
public interface LambdaDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Lambda Alias to shift traffic. Updating the version
     * of the alias will trigger a CodeDeploy deployment.
     */
    software.amazon.awscdk.services.lambda.Alias getAlias();
    /**
     * Lambda Alias to shift traffic. Updating the version
     * of the alias will trigger a CodeDeploy deployment.
     */
    void setAlias(final software.amazon.awscdk.services.lambda.Alias value);
    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * @default []
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms();
    /**
     * The CloudWatch alarms associated with this Deployment Group.
     * CodeDeploy will stop (and optionally roll back)
     * a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * @default []
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    void setAlarms(final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value);
    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     * @default one will be created for you
     */
    software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication();
    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     * @default one will be created for you
     */
    void setApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value);
    /**
     * The auto-rollback configuration for this Deployment Group.
     */
    software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback();
    /**
     * The auto-rollback configuration for this Deployment Group.
     */
    void setAutoRollback(final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value);
    /**
     * The Deployment Configuration this Deployment Group uses.
     * @default LambdaDeploymentConfig#AllAtOnce
     */
    software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * @default LambdaDeploymentConfig#AllAtOnce
     */
    void setDeploymentConfig(final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value);
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * @default an auto-generated name will be used
     */
    void setDeploymentGroupName(final java.lang.String value);
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * @default false
     */
    java.lang.Boolean getIgnorePollAlarmsFailure();
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * @default false
     */
    void setIgnorePollAlarmsFailure(final java.lang.Boolean value);
    /**
     * The Lambda function to run after traffic routing starts.
     */
    software.amazon.awscdk.services.lambda.IFunction getPostHook();
    /**
     * The Lambda function to run after traffic routing starts.
     */
    void setPostHook(final software.amazon.awscdk.services.lambda.IFunction value);
    /**
     * The Lambda function to run before traffic routing starts.
     */
    software.amazon.awscdk.services.lambda.IFunction getPreHook();
    /**
     * The Lambda function to run before traffic routing starts.
     */
    void setPreHook(final software.amazon.awscdk.services.lambda.IFunction value);
    /**
     * The service Role of this Deployment Group.
     * @default a new Role will be created.
     */
    software.amazon.awscdk.services.iam.IRole getRole();
    /**
     * The service Role of this Deployment Group.
     * @default a new Role will be created.
     */
    void setRole(final software.amazon.awscdk.services.iam.IRole value);

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentGroupProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.lambda.Alias _alias;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> _alarms;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication _application;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig _autoRollback;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig _deploymentConfig;
        @javax.annotation.Nullable
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePollAlarmsFailure;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.IFunction _postHook;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.IFunction _preHook;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;

        /**
         * Sets the value of Alias
         * @param value Lambda Alias to shift traffic. Updating the version
of the alias will trigger a CodeDeploy deployment.
         * @return {@code this}
         */
        public Builder withAlias(final software.amazon.awscdk.services.lambda.Alias value) {
            this._alias = java.util.Objects.requireNonNull(value, "alias is required");
            return this;
        }
        /**
         * Sets the value of Alarms
         * @param value The CloudWatch alarms associated with this Deployment Group.
CodeDeploy will stop (and optionally roll back)
a deployment if during it any of the alarms trigger.

Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @return {@code this}
         */
        public Builder withAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
            this._alarms = value;
            return this;
        }
        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        public Builder withApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this._application = value;
            return this;
        }
        /**
         * Sets the value of AutoRollback
         * @param value The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        public Builder withAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentGroupName = value;
            return this;
        }
        /**
         * Sets the value of IgnorePollAlarmsFailure
         * @param value Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        public Builder withIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }
        /**
         * Sets the value of PostHook
         * @param value The Lambda function to run after traffic routing starts.
         * @return {@code this}
         */
        public Builder withPostHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this._postHook = value;
            return this;
        }
        /**
         * Sets the value of PreHook
         * @param value The Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        public Builder withPreHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this._preHook = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The service Role of this Deployment Group.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LambdaDeploymentGroupProps build() {
            return new LambdaDeploymentGroupProps() {
                private software.amazon.awscdk.services.lambda.Alias $alias = java.util.Objects.requireNonNull(_alias, "alias is required");
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> $alarms = _alarms;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.ILambdaApplication $application = _application;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig $autoRollback = _autoRollback;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig $deploymentConfig = _deploymentConfig;
                @javax.annotation.Nullable
                private java.lang.String $deploymentGroupName = _deploymentGroupName;
                @javax.annotation.Nullable
                private java.lang.Boolean $ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.lambda.IFunction $postHook = _postHook;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.lambda.IFunction $preHook = _preHook;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.iam.IRole $role = _role;

                @Override
                public software.amazon.awscdk.services.lambda.Alias getAlias() {
                    return this.$alias;
                }

                @Override
                public void setAlias(final software.amazon.awscdk.services.lambda.Alias value) {
                    this.$alias = java.util.Objects.requireNonNull(value, "alias is required");
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public void setAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
                    this.$alarms = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
                    this.$application = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public void setAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
                    this.$autoRollback = value;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value) {
                    this.$deploymentConfig = value;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$deploymentGroupName = value;
                }

                @Override
                public java.lang.Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public void setIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$ignorePollAlarmsFailure = value;
                }

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getPostHook() {
                    return this.$postHook;
                }

                @Override
                public void setPostHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
                    this.$postHook = value;
                }

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getPreHook() {
                    return this.$preHook;
                }

                @Override
                public void setPreHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
                    this.$preHook = value;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                @Override
                public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
                    this.$role = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Lambda Alias to shift traffic. Updating the version
         * of the alias will trigger a CodeDeploy deployment.
         */
        @Override
        public software.amazon.awscdk.services.lambda.Alias getAlias() {
            return this.jsiiGet("alias", software.amazon.awscdk.services.lambda.Alias.class);
        }

        /**
         * Lambda Alias to shift traffic. Updating the version
         * of the alias will trigger a CodeDeploy deployment.
         */
        @Override
        public void setAlias(final software.amazon.awscdk.services.lambda.Alias value) {
            this.jsiiSet("alias", java.util.Objects.requireNonNull(value, "alias is required"));
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @default []
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
            return this.jsiiGet("alarms", java.util.List.class);
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group.
         * CodeDeploy will stop (and optionally roll back)
         * a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * @default []
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        public void setAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
            this.jsiiSet("alarms", value);
        }

        /**
         * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @default one will be created for you
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
        }

        /**
         * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @default one will be created for you
         */
        @Override
        public void setApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this.jsiiSet("application", value);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.jsiiGet("autoRollback", software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         */
        @Override
        public void setAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this.jsiiSet("autoRollback", value);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * @default LambdaDeploymentConfig#AllAtOnce
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * @default LambdaDeploymentConfig#AllAtOnce
         */
        @Override
        public void setDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value) {
            this.jsiiSet("deploymentConfig", value);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * @default an auto-generated name will be used
         */
        @Override
        public void setDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", value);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.jsiiGet("ignorePollAlarmsFailure", java.lang.Boolean.class);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @default false
         */
        @Override
        public void setIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("ignorePollAlarmsFailure", value);
        }

        /**
         * The Lambda function to run after traffic routing starts.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.IFunction getPostHook() {
            return this.jsiiGet("postHook", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * The Lambda function to run after traffic routing starts.
         */
        @Override
        public void setPostHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this.jsiiSet("postHook", value);
        }

        /**
         * The Lambda function to run before traffic routing starts.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.IFunction getPreHook() {
            return this.jsiiGet("preHook", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * The Lambda function to run before traffic routing starts.
         */
        @Override
        public void setPreHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this.jsiiSet("preHook", value);
        }

        /**
         * The service Role of this Deployment Group.
         * @default a new Role will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * The service Role of this Deployment Group.
         * @default a new Role will be created.
         */
        @Override
        public void setRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this.jsiiSet("role", value);
        }
    }
}
