package software.amazon.awscdk.services.codedeploy;

/**
 * Common properties for creating a {@link PipelineDeployAction},
 * either directly, through its constructor,
 * or through {@link IServerDeploymentGroup#toCodePipelineDeployAction}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T13:02:28.187Z")
public interface CommonPipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The source to use as input for deployment.
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for deployment.
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);

    /**
     * @return a {@link Builder} of {@link CommonPipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CommonPipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonPipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CommonPipelineDeployActionProps build() {
            return new CommonPipelineDeployActionProps() {
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                private java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public void setActionName(final java.lang.String value) {
                    this.$actionName = java.util.Objects.requireNonNull(value, "actionName is required");
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The source to use as input for deployment.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for deployment.
         */
        @Override
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public void setActionName(final java.lang.String value) {
            this.jsiiSet("actionName", java.util.Objects.requireNonNull(value, "actionName is required"));
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }
    }
}
