package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 * @see LambdaDeploymentConfig#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T13:02:28.195Z")
public interface LambdaDeploymentConfigImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
     * that we are referencing.
     */
    java.lang.String getDeploymentConfigName();
    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
     * that we are referencing.
     */
    void setDeploymentConfigName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentConfigImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentConfigImportProps}
     */
    final class Builder {
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentConfigImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LambdaDeploymentConfigImportProps build() {
            return new LambdaDeploymentConfigImportProps() {
                private java.lang.String $deploymentConfigName = java.util.Objects.requireNonNull(_deploymentConfigName, "deploymentConfigName is required");

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                @Override
                public void setDeploymentConfigName(final java.lang.String value) {
                    this.$deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
         * that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
         * that we are referencing.
         */
        @Override
        public void setDeploymentConfigName(final java.lang.String value) {
            this.jsiiSet("deploymentConfigName", java.util.Objects.requireNonNull(value, "deploymentConfigName is required"));
        }
    }
}
