package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Group.
 * @see ILambdaDeploymentGroup#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T13:02:28.197Z")
public interface LambdaDeploymentGroupImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy Lambda Application
     * that this Deployment Group belongs to.
     */
    software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication();
    /**
     * The reference to the CodeDeploy Lambda Application
     * that this Deployment Group belongs to.
     */
    void setApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value);
    /**
     * The physical, human-readable name of the CodeDeploy Lambda Deployment Group
     * that we are referencing.
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The physical, human-readable name of the CodeDeploy Lambda Deployment Group
     * that we are referencing.
     */
    void setDeploymentGroupName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentGroupImportProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication _application;
        private java.lang.String _deploymentGroupName;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy Lambda Application
that this Deployment Group belongs to.
         * @return {@code this}
         */
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Lambda Deployment Group
that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LambdaDeploymentGroupImportProps build() {
            return new LambdaDeploymentGroupImportProps() {
                private software.amazon.awscdk.services.codedeploy.ILambdaApplication $application = java.util.Objects.requireNonNull(_application, "application is required");
                private java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public void setApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
                    this.$application = java.util.Objects.requireNonNull(value, "application is required");
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public void setDeploymentGroupName(final java.lang.String value) {
                    this.$deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy Lambda Application
         * that this Deployment Group belongs to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
        }

        /**
         * The reference to the CodeDeploy Lambda Application
         * that this Deployment Group belongs to.
         */
        @Override
        public void setApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this.jsiiSet("application", java.util.Objects.requireNonNull(value, "application is required"));
        }

        /**
         * The physical, human-readable name of the CodeDeploy Lambda Deployment Group
         * that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Lambda Deployment Group
         * that we are referencing.
         */
        @Override
        public void setDeploymentGroupName(final java.lang.String value) {
            this.jsiiSet("deploymentGroupName", java.util.Objects.requireNonNull(value, "deploymentGroupName is required"));
        }
    }
}
