package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Application.
 * @see ILambdaApplication#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:40:38.993Z")
public interface LambdaApplicationImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the Lambda Application we're referencing.
     * The Application must be in the same account and region as the root Stack.
     */
    java.lang.String getApplicationName();

    /**
     * @return a {@link Builder} of {@link LambdaApplicationImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaApplicationImportProps}
     */
    final class Builder {
        private java.lang.String _applicationName;

        /**
         * Sets the value of ApplicationName
         * @param value The physical, human-readable name of the Lambda Application we're referencing.
The Application must be in the same account and region as the root Stack.
         * @return {@code this}
         */
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaApplicationImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LambdaApplicationImportProps build() {
            return new LambdaApplicationImportProps() {
                private final java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaApplicationImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the Lambda Application we're referencing.
         * The Application must be in the same account and region as the root Stack.
         */
        @Override
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }
    }
}
