package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties of the {@link PipelineDeployAction CodeDeploy deploy CodePipeline Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:40:39.003Z")
public interface PipelineDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.CommonPipelineDeployActionProps {
    /**
     * The CodeDeploy Deployment Group to deploy to.
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup();

    /**
     * @return a {@link Builder} of {@link PipelineDeployActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PipelineDeployActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup _deploymentGroup;
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        private java.lang.String _actionName;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;

        /**
         * Sets the value of DeploymentGroup
         * @param value The CodeDeploy Deployment Group to deploy to.
         * @return {@code this}
         */
        public Builder withDeploymentGroup(final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup value) {
            this._deploymentGroup = java.util.Objects.requireNonNull(value, "deploymentGroup is required");
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for deployment.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of ActionName
         * @param value The physical, human-readable name of the Action.
Not that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        public Builder withActionName(final java.lang.String value) {
            this._actionName = java.util.Objects.requireNonNull(value, "actionName is required");
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PipelineDeployActionProps build() {
            return new PipelineDeployActionProps() {
                private final software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup $deploymentGroup = java.util.Objects.requireNonNull(_deploymentGroup, "deploymentGroup is required");
                private final software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                private final java.lang.String $actionName = java.util.Objects.requireNonNull(_actionName, "actionName is required");
                @javax.annotation.Nullable
                private final java.lang.Number $runOrder = _runOrder;

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup() {
                    return this.$deploymentGroup;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public java.lang.String getActionName() {
                    return this.$actionName;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("deploymentGroup", om.valueToTree(this.getDeploymentGroup()));
                    obj.set("inputArtifact", om.valueToTree(this.getInputArtifact()));
                    obj.set("actionName", om.valueToTree(this.getActionName()));
                    obj.set("runOrder", om.valueToTree(this.getRunOrder()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.PipelineDeployActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CodeDeploy Deployment Group to deploy to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup getDeploymentGroup() {
            return this.jsiiGet("deploymentGroup", software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup.class);
        }

        /**
         * The source to use as input for deployment.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The physical, human-readable name of the Action.
         * Not that Action names must be unique within a single Stage.
         */
        @Override
        public java.lang.String getActionName() {
            return this.jsiiGet("actionName", java.lang.String.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }
    }
}
