package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Configuration.
 * @see ServerDeploymentConfig#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:10:23.432Z")
public interface ServerDeploymentConfigImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
     * that we are referencing.
     */
    java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentConfigImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentConfigImportProps}
     */
    final class Builder {
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentConfigImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentConfigImportProps build() {
            return new ServerDeploymentConfigImportProps() {
                private final java.lang.String $deploymentConfigName = java.util.Objects.requireNonNull(_deploymentConfigName, "deploymentConfigName is required");

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
         * that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
