/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.codedeploy.AutoRollbackConfig;
import software.amazon.awscdk.services.codedeploy.IServerApplication;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig;
import software.amazon.awscdk.services.codedeploy.InstanceTagSet;
import software.amazon.awscdk.services.codedeploy.api.ILoadBalancer;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ServerDeploymentGroupProps
extends JsiiSerializable {
    public List<Alarm> getAlarms();

    public IServerApplication getApplication();

    public AutoRollbackConfig getAutoRollback();

    public List<AutoScalingGroup> getAutoScalingGroups();

    public IServerDeploymentConfig getDeploymentConfig();

    public String getDeploymentGroupName();

    public InstanceTagSet getEc2InstanceTags();

    public Boolean getIgnorePollAlarmsFailure();

    public Boolean getInstallAgent();

    public ILoadBalancer getLoadBalancer();

    public InstanceTagSet getOnPremiseInstanceTags();

    public Role getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<Alarm> _alarms;
        @Nullable
        private IServerApplication _application;
        @Nullable
        private AutoRollbackConfig _autoRollback;
        @Nullable
        private List<AutoScalingGroup> _autoScalingGroups;
        @Nullable
        private IServerDeploymentConfig _deploymentConfig;
        @Nullable
        private String _deploymentGroupName;
        @Nullable
        private InstanceTagSet _ec2InstanceTags;
        @Nullable
        private Boolean _ignorePollAlarmsFailure;
        @Nullable
        private Boolean _installAgent;
        @Nullable
        private ILoadBalancer _loadBalancer;
        @Nullable
        private InstanceTagSet _onPremiseInstanceTags;
        @Nullable
        private Role _role;

        public Builder withAlarms(@Nullable List<Alarm> value) {
            this._alarms = value;
            return this;
        }

        public Builder withApplication(@Nullable IServerApplication value) {
            this._application = value;
            return this;
        }

        public Builder withAutoRollback(@Nullable AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }

        public Builder withAutoScalingGroups(@Nullable List<AutoScalingGroup> value) {
            this._autoScalingGroups = value;
            return this;
        }

        public Builder withDeploymentConfig(@Nullable IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public Builder withDeploymentGroupName(@Nullable String value) {
            this._deploymentGroupName = value;
            return this;
        }

        public Builder withEc2InstanceTags(@Nullable InstanceTagSet value) {
            this._ec2InstanceTags = value;
            return this;
        }

        public Builder withIgnorePollAlarmsFailure(@Nullable Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }

        public Builder withInstallAgent(@Nullable Boolean value) {
            this._installAgent = value;
            return this;
        }

        public Builder withLoadBalancer(@Nullable ILoadBalancer value) {
            this._loadBalancer = value;
            return this;
        }

        public Builder withOnPremiseInstanceTags(@Nullable InstanceTagSet value) {
            this._onPremiseInstanceTags = value;
            return this;
        }

        public Builder withRole(@Nullable Role value) {
            this._role = value;
            return this;
        }

        public ServerDeploymentGroupProps build() {
            return new ServerDeploymentGroupProps(){
                @Nullable
                private final List<Alarm> $alarms;
                @Nullable
                private final IServerApplication $application;
                @Nullable
                private final AutoRollbackConfig $autoRollback;
                @Nullable
                private final List<AutoScalingGroup> $autoScalingGroups;
                @Nullable
                private final IServerDeploymentConfig $deploymentConfig;
                @Nullable
                private final String $deploymentGroupName;
                @Nullable
                private final InstanceTagSet $ec2InstanceTags;
                @Nullable
                private final Boolean $ignorePollAlarmsFailure;
                @Nullable
                private final Boolean $installAgent;
                @Nullable
                private final ILoadBalancer $loadBalancer;
                @Nullable
                private final InstanceTagSet $onPremiseInstanceTags;
                @Nullable
                private final Role $role;
                {
                    this.$alarms = _alarms;
                    this.$application = _application;
                    this.$autoRollback = _autoRollback;
                    this.$autoScalingGroups = _autoScalingGroups;
                    this.$deploymentConfig = _deploymentConfig;
                    this.$deploymentGroupName = _deploymentGroupName;
                    this.$ec2InstanceTags = _ec2InstanceTags;
                    this.$ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                    this.$installAgent = _installAgent;
                    this.$loadBalancer = _loadBalancer;
                    this.$onPremiseInstanceTags = _onPremiseInstanceTags;
                    this.$role = _role;
                }

                @Override
                public List<Alarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public List<AutoScalingGroup> getAutoScalingGroups() {
                    return this.$autoScalingGroups;
                }

                @Override
                public IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public InstanceTagSet getEc2InstanceTags() {
                    return this.$ec2InstanceTags;
                }

                @Override
                public Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public Boolean getInstallAgent() {
                    return this.$installAgent;
                }

                @Override
                public ILoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public InstanceTagSet getOnPremiseInstanceTags() {
                    return this.$onPremiseInstanceTags;
                }

                @Override
                public Role getRole() {
                    return this.$role;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("alarms", om.valueToTree(this.getAlarms()));
                    obj.set("application", om.valueToTree((Object)this.getApplication()));
                    obj.set("autoRollback", om.valueToTree((Object)this.getAutoRollback()));
                    obj.set("autoScalingGroups", om.valueToTree(this.getAutoScalingGroups()));
                    obj.set("deploymentConfig", om.valueToTree((Object)this.getDeploymentConfig()));
                    obj.set("deploymentGroupName", om.valueToTree((Object)this.getDeploymentGroupName()));
                    obj.set("ec2InstanceTags", om.valueToTree((Object)this.getEc2InstanceTags()));
                    obj.set("ignorePollAlarmsFailure", om.valueToTree((Object)this.getIgnorePollAlarmsFailure()));
                    obj.set("installAgent", om.valueToTree((Object)this.getInstallAgent()));
                    obj.set("loadBalancer", om.valueToTree((Object)this.getLoadBalancer()));
                    obj.set("onPremiseInstanceTags", om.valueToTree((Object)this.getOnPremiseInstanceTags()));
                    obj.set("role", om.valueToTree((Object)this.getRole()));
                    return obj;
                }
            };
        }
    }
}

