package software.amazon.awscdk.services.codedeploy;

/**
 * Represents a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * If you're managing the Deployment Group alongside the rest of your CDK resources,
 * use the {@link ServerDeploymentGroup} class.
 * 
 * If you want to reference an already existing Deployment Group,
 * or one defined in a different CDK Stack,
 * use the {@link #import} method.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:06:27.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.ServerDeploymentGroupBase")
public abstract class ServerDeploymentGroupBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.codedeploy.IServerDeploymentGroup {
    protected ServerDeploymentGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public ServerDeploymentGroupBase(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig deploymentConfig) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), deploymentConfig });
    }
    public ServerDeploymentGroupBase(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    @Override
    public abstract software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps export();

    @Override
    public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
        return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
    }

    @Override
    public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
        return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
    }

    @Override
    public java.lang.String getDeploymentGroupArn() {
        return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
    }

    @Override
    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    @Override
    @javax.annotation.Nullable
    public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
        return this.jsiiGet("autoScalingGroups", java.util.List.class);
    }

    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.iam.Role getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        @Override
        public java.lang.String getDeploymentGroupArn() {
            return this.jsiiGet("deploymentGroupArn", java.lang.String.class);
        }

        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.util.List.class);
        }

        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable.
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        @Override
        public software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupImportProps.class);
        }
    }
}
