/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codedeploy.IServerApplication;
import software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ServerDeploymentGroupImportProps
extends JsiiSerializable {
    public IServerApplication getApplication();

    public String getDeploymentGroupName();

    public IServerDeploymentConfig getDeploymentConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IServerApplication _application;
        private String _deploymentGroupName;
        @Nullable
        private IServerDeploymentConfig _deploymentConfig;

        public Builder withApplication(IServerApplication value) {
            this._application = Objects.requireNonNull(value, "application is required");
            return this;
        }

        public Builder withDeploymentGroupName(String value) {
            this._deploymentGroupName = Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }

        public Builder withDeploymentConfig(@Nullable IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        public ServerDeploymentGroupImportProps build() {
            return new ServerDeploymentGroupImportProps(){
                private final IServerApplication $application;
                private final String $deploymentGroupName;
                @Nullable
                private final IServerDeploymentConfig $deploymentConfig;
                {
                    this.$application = Objects.requireNonNull(_application, "application is required");
                    this.$deploymentGroupName = Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                    this.$deploymentConfig = _deploymentConfig;
                }

                @Override
                public IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree((Object)this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree((Object)this.getDeploymentGroupName()));
                    obj.set("deploymentConfig", om.valueToTree((Object)this.getDeploymentConfig()));
                    return obj;
                }
            };
        }
    }
}

