package software.amazon.awscdk.services.codedeploy;

/**
 * A CloudFormation `AWS::CodeDeploy::DeploymentGroup`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:13:42.098Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codedeploy.$Module.class, fqn = "@aws-cdk/aws-codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup extends software.amazon.awscdk.CfnResource {
    protected CfnDeploymentGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::CodeDeploy::DeploymentGroup`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnDeploymentGroup(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getDeploymentGroupName() {
        return this.jsiiGet("deploymentGroupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html
     */
    public static interface AlarmConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
         */
        java.lang.Object getAlarms();
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
         */
        java.lang.Object getIgnorePollAlarmFailure();

        /**
         * @return a {@link Builder} of {@link AlarmConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _alarms;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _ignorePollAlarmFailure;

            /**
             * Sets the value of Alarms
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Alarms
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
             * @return {@code this}
             */
            public Builder withAlarms(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._alarms = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }
            /**
             * Sets the value of IgnorePollAlarmFailure
             * @param value `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
             * @return {@code this}
             */
            public Builder withIgnorePollAlarmFailure(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignorePollAlarmFailure = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmConfigurationProperty build() {
                return new AlarmConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $alarms = _alarms;
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ignorePollAlarmFailure = _ignorePollAlarmFailure;

                    @Override
                    public java.lang.Object getAlarms() {
                        return this.$alarms;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.lang.Object getIgnorePollAlarmFailure() {
                        return this.$ignorePollAlarmFailure;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("alarms", om.valueToTree(this.getAlarms()));
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("ignorePollAlarmFailure", om.valueToTree(this.getIgnorePollAlarmFailure()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.AlarmConfigurationProperty.Alarms`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-alarms
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAlarms() {
                return this.jsiiGet("alarms", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.AlarmConfigurationProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.AlarmConfigurationProperty.IgnorePollAlarmFailure`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarmconfiguration.html#cfn-codedeploy-deploymentgroup-alarmconfiguration-ignorepollalarmfailure
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnorePollAlarmFailure() {
                return this.jsiiGet("ignorePollAlarmFailure", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html
     */
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.AlarmProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
         */
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AlarmProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value `CfnDeploymentGroup.AlarmProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AlarmProperty build() {
                return new AlarmProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AlarmProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.AlarmProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-alarm.html#cfn-codedeploy-deploymentgroup-alarm-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html
     */
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
         */
        java.lang.Object getEnabled();
        /**
         * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
         */
        java.util.List<java.lang.String> getEvents();

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _events;

            /**
             * Sets the value of Enabled
             * @param value `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Events
             * @param value `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
             * @return {@code this}
             */
            public Builder withEvents(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._events = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AutoRollbackConfigurationProperty build() {
                return new AutoRollbackConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $events = _events;

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public java.util.List<java.lang.String> getEvents() {
                        return this.$events;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("enabled", om.valueToTree(this.getEnabled()));
                        obj.set("events", om.valueToTree(this.getEvents()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Enabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.AutoRollbackConfigurationProperty.Events`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-autorollbackconfiguration.html#cfn-codedeploy-deploymentgroup-autorollbackconfiguration-events
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getEvents() {
                return this.jsiiGet("events", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html
     */
    public static interface DeploymentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.DeploymentProperty.Revision`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
         */
        java.lang.Object getRevision();
        /**
         * `CfnDeploymentGroup.DeploymentProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
         */
        java.lang.String getDescription();
        /**
         * `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
         */
        java.lang.Object getIgnoreApplicationStopFailures();

        /**
         * @return a {@link Builder} of {@link DeploymentProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentProperty}
         */
        final class Builder {
            private java.lang.Object _revision;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.lang.Object _ignoreApplicationStopFailures;

            /**
             * Sets the value of Revision
             * @param value `CfnDeploymentGroup.DeploymentProperty.Revision`.
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.Token value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Revision
             * @param value `CfnDeploymentGroup.DeploymentProperty.Revision`.
             * @return {@code this}
             */
            public Builder withRevision(final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty value) {
                this._revision = java.util.Objects.requireNonNull(value, "revision is required");
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnDeploymentGroup.DeploymentProperty.Description`.
             * @return {@code this}
             */
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }
            /**
             * Sets the value of IgnoreApplicationStopFailures
             * @param value `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
             * @return {@code this}
             */
            public Builder withIgnoreApplicationStopFailures(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ignoreApplicationStopFailures = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentProperty build() {
                return new DeploymentProperty() {
                    private final java.lang.Object $revision = java.util.Objects.requireNonNull(_revision, "revision is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ignoreApplicationStopFailures = _ignoreApplicationStopFailures;

                    @Override
                    public java.lang.Object getRevision() {
                        return this.$revision;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.lang.Object getIgnoreApplicationStopFailures() {
                        return this.$ignoreApplicationStopFailures;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("revision", om.valueToTree(this.getRevision()));
                        obj.set("description", om.valueToTree(this.getDescription()));
                        obj.set("ignoreApplicationStopFailures", om.valueToTree(this.getIgnoreApplicationStopFailures()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.DeploymentProperty.Revision`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision
             */
            @Override
            public java.lang.Object getRevision() {
                return this.jsiiGet("revision", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.DeploymentProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-description
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.DeploymentProperty.IgnoreApplicationStopFailures`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment.html#cfn-properties-codedeploy-deploymentgroup-deployment-ignoreapplicationstopfailures
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIgnoreApplicationStopFailures() {
                return this.jsiiGet("ignoreApplicationStopFailures", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html
     */
    public static interface DeploymentStyleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
         */
        java.lang.String getDeploymentOption();
        /**
         * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
         */
        java.lang.String getDeploymentType();

        /**
         * @return a {@link Builder} of {@link DeploymentStyleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DeploymentStyleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _deploymentOption;
            @javax.annotation.Nullable
            private java.lang.String _deploymentType;

            /**
             * Sets the value of DeploymentOption
             * @param value `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
             * @return {@code this}
             */
            public Builder withDeploymentOption(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentOption = value;
                return this;
            }
            /**
             * Sets the value of DeploymentType
             * @param value `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
             * @return {@code this}
             */
            public Builder withDeploymentType(@javax.annotation.Nullable final java.lang.String value) {
                this._deploymentType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentStyleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public DeploymentStyleProperty build() {
                return new DeploymentStyleProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $deploymentOption = _deploymentOption;
                    @javax.annotation.Nullable
                    private final java.lang.String $deploymentType = _deploymentType;

                    @Override
                    public java.lang.String getDeploymentOption() {
                        return this.$deploymentOption;
                    }

                    @Override
                    public java.lang.String getDeploymentType() {
                        return this.$deploymentType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deploymentOption", om.valueToTree(this.getDeploymentOption()));
                        obj.set("deploymentType", om.valueToTree(this.getDeploymentType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.DeploymentStyleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentOption`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymentoption
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDeploymentOption() {
                return this.jsiiGet("deploymentOption", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.DeploymentStyleProperty.DeploymentType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deploymentstyle.html#cfn-codedeploy-deploymentgroup-deploymentstyle-deploymenttype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getDeploymentType() {
                return this.jsiiGet("deploymentType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html
     */
    public static interface EC2TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
         */
        java.lang.String getKey();
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
         */
        java.lang.String getType();
        /**
         * `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link EC2TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagFilterProperty build() {
                return new EC2TagFilterProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("type", om.valueToTree(this.getType()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.EC2TagFilterProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.EC2TagFilterProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.EC2TagFilterProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagfilter.html#cfn-codedeploy-deploymentgroup-ec2tagfilter-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html
     */
    public static interface EC2TagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
         */
        java.lang.Object getEc2TagGroup();

        /**
         * @return a {@link Builder} of {@link EC2TagSetListObjectProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagSetListObjectProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _ec2TagGroup;

            /**
             * Sets the value of Ec2TagGroup
             * @param value `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
             * @return {@code this}
             */
            public Builder withEc2TagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ec2TagGroup = value;
                return this;
            }
            /**
             * Sets the value of Ec2TagGroup
             * @param value `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
             * @return {@code this}
             */
            public Builder withEc2TagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ec2TagGroup = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagSetListObjectProperty build() {
                return new EC2TagSetListObjectProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $ec2TagGroup = _ec2TagGroup;

                    @Override
                    public java.lang.Object getEc2TagGroup() {
                        return this.$ec2TagGroup;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ec2TagGroup", om.valueToTree(this.getEc2TagGroup()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.EC2TagSetListObjectProperty.Ec2TagGroup`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagsetlistobject.html#cfn-codedeploy-deploymentgroup-ec2tagsetlistobject-ec2taggroup
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEc2TagGroup() {
                return this.jsiiGet("ec2TagGroup", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html
     */
    public static interface EC2TagSetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
         */
        java.lang.Object getEc2TagSetList();

        /**
         * @return a {@link Builder} of {@link EC2TagSetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EC2TagSetProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _ec2TagSetList;

            /**
             * Sets the value of Ec2TagSetList
             * @param value `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
             * @return {@code this}
             */
            public Builder withEc2TagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._ec2TagSetList = value;
                return this;
            }
            /**
             * Sets the value of Ec2TagSetList
             * @param value `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
             * @return {@code this}
             */
            public Builder withEc2TagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ec2TagSetList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EC2TagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public EC2TagSetProperty build() {
                return new EC2TagSetProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $ec2TagSetList = _ec2TagSetList;

                    @Override
                    public java.lang.Object getEc2TagSetList() {
                        return this.$ec2TagSetList;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ec2TagSetList", om.valueToTree(this.getEc2TagSetList()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagSetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.EC2TagSetProperty.Ec2TagSetList`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-ec2tagset.html#cfn-codedeploy-deploymentgroup-ec2tagset-ec2tagsetlist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEc2TagSetList() {
                return this.jsiiGet("ec2TagSetList", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html
     */
    public static interface ELBInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.ELBInfoProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
         */
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ELBInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ELBInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value `CfnDeploymentGroup.ELBInfoProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ELBInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ELBInfoProperty build() {
                return new ELBInfoProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.ELBInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.ELBInfoProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-elbinfo.html#cfn-codedeploy-deploymentgroup-elbinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html
     */
    public static interface GitHubLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.CommitId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
         */
        java.lang.String getCommitId();
        /**
         * `CfnDeploymentGroup.GitHubLocationProperty.Repository`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
         */
        java.lang.String getRepository();

        /**
         * @return a {@link Builder} of {@link GitHubLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link GitHubLocationProperty}
         */
        final class Builder {
            private java.lang.String _commitId;
            private java.lang.String _repository;

            /**
             * Sets the value of CommitId
             * @param value `CfnDeploymentGroup.GitHubLocationProperty.CommitId`.
             * @return {@code this}
             */
            public Builder withCommitId(final java.lang.String value) {
                this._commitId = java.util.Objects.requireNonNull(value, "commitId is required");
                return this;
            }
            /**
             * Sets the value of Repository
             * @param value `CfnDeploymentGroup.GitHubLocationProperty.Repository`.
             * @return {@code this}
             */
            public Builder withRepository(final java.lang.String value) {
                this._repository = java.util.Objects.requireNonNull(value, "repository is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitHubLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public GitHubLocationProperty build() {
                return new GitHubLocationProperty() {
                    private final java.lang.String $commitId = java.util.Objects.requireNonNull(_commitId, "commitId is required");
                    private final java.lang.String $repository = java.util.Objects.requireNonNull(_repository, "repository is required");

                    @Override
                    public java.lang.String getCommitId() {
                        return this.$commitId;
                    }

                    @Override
                    public java.lang.String getRepository() {
                        return this.$repository;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("commitId", om.valueToTree(this.getCommitId()));
                        obj.set("repository", om.valueToTree(this.getRepository()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.GitHubLocationProperty.CommitId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-commitid
             */
            @Override
            public java.lang.String getCommitId() {
                return this.jsiiGet("commitId", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.GitHubLocationProperty.Repository`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-githublocation.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation-repository
             */
            @Override
            public java.lang.String getRepository() {
                return this.jsiiGet("repository", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html
     */
    public static interface LoadBalancerInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
         */
        java.lang.Object getElbInfoList();
        /**
         * `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
         */
        java.lang.Object getTargetGroupInfoList();

        /**
         * @return a {@link Builder} of {@link LoadBalancerInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancerInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _elbInfoList;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupInfoList;

            /**
             * Sets the value of ElbInfoList
             * @param value `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of ElbInfoList
             * @param value `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
             * @return {@code this}
             */
            public Builder withElbInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._elbInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._targetGroupInfoList = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupInfoList
             * @param value `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
             * @return {@code this}
             */
            public Builder withTargetGroupInfoList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._targetGroupInfoList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public LoadBalancerInfoProperty build() {
                return new LoadBalancerInfoProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $elbInfoList = _elbInfoList;
                    @javax.annotation.Nullable
                    private final java.lang.Object $targetGroupInfoList = _targetGroupInfoList;

                    @Override
                    public java.lang.Object getElbInfoList() {
                        return this.$elbInfoList;
                    }

                    @Override
                    public java.lang.Object getTargetGroupInfoList() {
                        return this.$targetGroupInfoList;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("elbInfoList", om.valueToTree(this.getElbInfoList()));
                        obj.set("targetGroupInfoList", om.valueToTree(this.getTargetGroupInfoList()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.LoadBalancerInfoProperty.ElbInfoList`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-elbinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getElbInfoList() {
                return this.jsiiGet("elbInfoList", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.LoadBalancerInfoProperty.TargetGroupInfoList`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-loadbalancerinfo.html#cfn-codedeploy-deploymentgroup-loadbalancerinfo-targetgroupinfolist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupInfoList() {
                return this.jsiiGet("targetGroupInfoList", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html
     */
    public static interface OnPremisesTagSetListObjectProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
         */
        java.lang.Object getOnPremisesTagGroup();

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetListObjectProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OnPremisesTagSetListObjectProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _onPremisesTagGroup;

            /**
             * Sets the value of OnPremisesTagGroup
             * @param value `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
             * @return {@code this}
             */
            public Builder withOnPremisesTagGroup(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onPremisesTagGroup = value;
                return this;
            }
            /**
             * Sets the value of OnPremisesTagGroup
             * @param value `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
             * @return {@code this}
             */
            public Builder withOnPremisesTagGroup(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._onPremisesTagGroup = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetListObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OnPremisesTagSetListObjectProperty build() {
                return new OnPremisesTagSetListObjectProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $onPremisesTagGroup = _onPremisesTagGroup;

                    @Override
                    public java.lang.Object getOnPremisesTagGroup() {
                        return this.$onPremisesTagGroup;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("onPremisesTagGroup", om.valueToTree(this.getOnPremisesTagGroup()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.OnPremisesTagSetListObjectProperty.OnPremisesTagGroup`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagsetlistobject.html#cfn-codedeploy-deploymentgroup-onpremisestagsetlistobject-onpremisestaggroup
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnPremisesTagGroup() {
                return this.jsiiGet("onPremisesTagGroup", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html
     */
    public static interface OnPremisesTagSetProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
         */
        java.lang.Object getOnPremisesTagSetList();

        /**
         * @return a {@link Builder} of {@link OnPremisesTagSetProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OnPremisesTagSetProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _onPremisesTagSetList;

            /**
             * Sets the value of OnPremisesTagSetList
             * @param value `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
             * @return {@code this}
             */
            public Builder withOnPremisesTagSetList(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onPremisesTagSetList = value;
                return this;
            }
            /**
             * Sets the value of OnPremisesTagSetList
             * @param value `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
             * @return {@code this}
             */
            public Builder withOnPremisesTagSetList(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._onPremisesTagSetList = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnPremisesTagSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OnPremisesTagSetProperty build() {
                return new OnPremisesTagSetProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $onPremisesTagSetList = _onPremisesTagSetList;

                    @Override
                    public java.lang.Object getOnPremisesTagSetList() {
                        return this.$onPremisesTagSetList;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("onPremisesTagSetList", om.valueToTree(this.getOnPremisesTagSetList()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.OnPremisesTagSetProperty.OnPremisesTagSetList`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-onpremisestagset.html#cfn-codedeploy-deploymentgroup-onpremisestagset-onpremisestagsetlist
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnPremisesTagSetList() {
                return this.jsiiGet("onPremisesTagSetList", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html
     */
    public static interface RevisionLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
         */
        java.lang.Object getGitHubLocation();
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
         */
        java.lang.String getRevisionType();
        /**
         * `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
         */
        java.lang.Object getS3Location();

        /**
         * @return a {@link Builder} of {@link RevisionLocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RevisionLocationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _gitHubLocation;
            @javax.annotation.Nullable
            private java.lang.String _revisionType;
            @javax.annotation.Nullable
            private java.lang.Object _s3Location;

            /**
             * Sets the value of GitHubLocation
             * @param value `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of GitHubLocation
             * @param value `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
             * @return {@code this}
             */
            public Builder withGitHubLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.GitHubLocationProperty value) {
                this._gitHubLocation = value;
                return this;
            }
            /**
             * Sets the value of RevisionType
             * @param value `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
             * @return {@code this}
             */
            public Builder withRevisionType(@javax.annotation.Nullable final java.lang.String value) {
                this._revisionType = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._s3Location = value;
                return this;
            }
            /**
             * Sets the value of S3Location
             * @param value `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
             * @return {@code this}
             */
            public Builder withS3Location(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty value) {
                this._s3Location = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RevisionLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RevisionLocationProperty build() {
                return new RevisionLocationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $gitHubLocation = _gitHubLocation;
                    @javax.annotation.Nullable
                    private final java.lang.String $revisionType = _revisionType;
                    @javax.annotation.Nullable
                    private final java.lang.Object $s3Location = _s3Location;

                    @Override
                    public java.lang.Object getGitHubLocation() {
                        return this.$gitHubLocation;
                    }

                    @Override
                    public java.lang.String getRevisionType() {
                        return this.$revisionType;
                    }

                    @Override
                    public java.lang.Object getS3Location() {
                        return this.$s3Location;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("gitHubLocation", om.valueToTree(this.getGitHubLocation()));
                        obj.set("revisionType", om.valueToTree(this.getRevisionType()));
                        obj.set("s3Location", om.valueToTree(this.getS3Location()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.RevisionLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.RevisionLocationProperty.GitHubLocation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-githublocation
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getGitHubLocation() {
                return this.jsiiGet("gitHubLocation", java.lang.Object.class);
            }

            /**
             * `CfnDeploymentGroup.RevisionLocationProperty.RevisionType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-revisiontype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRevisionType() {
                return this.jsiiGet("revisionType", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.RevisionLocationProperty.S3Location`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getS3Location() {
                return this.jsiiGet("s3Location", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
         */
        java.lang.String getBucket();
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
         */
        java.lang.String getKey();
        /**
         * `CfnDeploymentGroup.S3LocationProperty.BundleType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
         */
        java.lang.String getBundleType();
        /**
         * `CfnDeploymentGroup.S3LocationProperty.ETag`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
         */
        java.lang.String getETag();
        /**
         * `CfnDeploymentGroup.S3LocationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
         */
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3LocationProperty}
         */
        final class Builder {
            private java.lang.String _bucket;
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _bundleType;
            @javax.annotation.Nullable
            private java.lang.String _eTag;
            @javax.annotation.Nullable
            private java.lang.String _version;

            /**
             * Sets the value of Bucket
             * @param value `CfnDeploymentGroup.S3LocationProperty.Bucket`.
             * @return {@code this}
             */
            public Builder withBucket(final java.lang.String value) {
                this._bucket = java.util.Objects.requireNonNull(value, "bucket is required");
                return this;
            }
            /**
             * Sets the value of Key
             * @param value `CfnDeploymentGroup.S3LocationProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of BundleType
             * @param value `CfnDeploymentGroup.S3LocationProperty.BundleType`.
             * @return {@code this}
             */
            public Builder withBundleType(@javax.annotation.Nullable final java.lang.String value) {
                this._bundleType = value;
                return this;
            }
            /**
             * Sets the value of ETag
             * @param value `CfnDeploymentGroup.S3LocationProperty.ETag`.
             * @return {@code this}
             */
            public Builder withETag(@javax.annotation.Nullable final java.lang.String value) {
                this._eTag = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value `CfnDeploymentGroup.S3LocationProperty.Version`.
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public S3LocationProperty build() {
                return new S3LocationProperty() {
                    private final java.lang.String $bucket = java.util.Objects.requireNonNull(_bucket, "bucket is required");
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $bundleType = _bundleType;
                    @javax.annotation.Nullable
                    private final java.lang.String $eTag = _eTag;
                    @javax.annotation.Nullable
                    private final java.lang.String $version = _version;

                    @Override
                    public java.lang.String getBucket() {
                        return this.$bucket;
                    }

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getBundleType() {
                        return this.$bundleType;
                    }

                    @Override
                    public java.lang.String getETag() {
                        return this.$eTag;
                    }

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucket", om.valueToTree(this.getBucket()));
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("bundleType", om.valueToTree(this.getBundleType()));
                        obj.set("eTag", om.valueToTree(this.getETag()));
                        obj.set("version", om.valueToTree(this.getVersion()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.S3LocationProperty.Bucket`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bucket
             */
            @Override
            public java.lang.String getBucket() {
                return this.jsiiGet("bucket", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.S3LocationProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-key
             */
            @Override
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.S3LocationProperty.BundleType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-bundletype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getBundleType() {
                return this.jsiiGet("bundleType", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.S3LocationProperty.ETag`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-etag
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getETag() {
                return this.jsiiGet("eTag", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.S3LocationProperty.Version`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-deployment-revision-s3location.html#cfn-properties-codedeploy-deploymentgroup-deployment-revision-s3location-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html
     */
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
         */
        java.lang.String getKey();
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
         */
        java.lang.String getType();
        /**
         * `CfnDeploymentGroup.TagFilterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagFilterProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _key;
            @javax.annotation.Nullable
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Key
             * @param value `CfnDeploymentGroup.TagFilterProperty.Key`.
             * @return {@code this}
             */
            public Builder withKey(@javax.annotation.Nullable final java.lang.String value) {
                this._key = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value `CfnDeploymentGroup.TagFilterProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnDeploymentGroup.TagFilterProperty.Value`.
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TagFilterProperty build() {
                return new TagFilterProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $key = _key;
                    @javax.annotation.Nullable
                    private final java.lang.String $type = _type;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("type", om.valueToTree(this.getType()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TagFilterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.TagFilterProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-key
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.TagFilterProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.TagFilterProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-tagfilter.html#cfn-codedeploy-deploymentgroup-tagfilter-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html
     */
    public static interface TargetGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
         */
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link TargetGroupInfoProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TargetGroupInfoProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _name;

            /**
             * Sets the value of Name
             * @param value `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TargetGroupInfoProperty build() {
                return new TargetGroupInfoProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $name = _name;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.TargetGroupInfoProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-targetgroupinfo.html#cfn-codedeploy-deploymentgroup-targetgroupinfo-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html
     */
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
         */
        java.util.List<java.lang.String> getTriggerEvents();
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
         */
        java.lang.String getTriggerName();
        /**
         * `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
         */
        java.lang.String getTriggerTargetArn();

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TriggerConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _triggerEvents;
            @javax.annotation.Nullable
            private java.lang.String _triggerName;
            @javax.annotation.Nullable
            private java.lang.String _triggerTargetArn;

            /**
             * Sets the value of TriggerEvents
             * @param value `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
             * @return {@code this}
             */
            public Builder withTriggerEvents(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._triggerEvents = value;
                return this;
            }
            /**
             * Sets the value of TriggerName
             * @param value `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
             * @return {@code this}
             */
            public Builder withTriggerName(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerName = value;
                return this;
            }
            /**
             * Sets the value of TriggerTargetArn
             * @param value `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
             * @return {@code this}
             */
            public Builder withTriggerTargetArn(@javax.annotation.Nullable final java.lang.String value) {
                this._triggerTargetArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TriggerConfigProperty build() {
                return new TriggerConfigProperty() {
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $triggerEvents = _triggerEvents;
                    @javax.annotation.Nullable
                    private final java.lang.String $triggerName = _triggerName;
                    @javax.annotation.Nullable
                    private final java.lang.String $triggerTargetArn = _triggerTargetArn;

                    @Override
                    public java.util.List<java.lang.String> getTriggerEvents() {
                        return this.$triggerEvents;
                    }

                    @Override
                    public java.lang.String getTriggerName() {
                        return this.$triggerName;
                    }

                    @Override
                    public java.lang.String getTriggerTargetArn() {
                        return this.$triggerTargetArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("triggerEvents", om.valueToTree(this.getTriggerEvents()));
                        obj.set("triggerName", om.valueToTree(this.getTriggerName()));
                        obj.set("triggerTargetArn", om.valueToTree(this.getTriggerTargetArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TriggerConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnDeploymentGroup.TriggerConfigProperty.TriggerEvents`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggerevents
             */
            @Override
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getTriggerEvents() {
                return this.jsiiGet("triggerEvents", java.util.List.class);
            }

            /**
             * `CfnDeploymentGroup.TriggerConfigProperty.TriggerName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggername
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTriggerName() {
                return this.jsiiGet("triggerName", java.lang.String.class);
            }

            /**
             * `CfnDeploymentGroup.TriggerConfigProperty.TriggerTargetArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-triggerconfig.html#cfn-codedeploy-deploymentgroup-triggerconfig-triggertargetarn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTriggerTargetArn() {
                return this.jsiiGet("triggerTargetArn", java.lang.String.class);
            }
        }
    }
}
