package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link ServerDeploymentGroup}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:56:00.237Z")
public interface ServerDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * 
     * Default: []
     * 
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms();
    /**
     * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to. If you don't provide one, a new Application will be created.
     */
    software.amazon.awscdk.services.codedeploy.IServerApplication getApplication();
    /**
     * The auto-rollback configuration for this Deployment Group.
     */
    software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback();
    /**
     * The auto-scaling groups belonging to this Deployment Group.
     * 
     * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
     * 
     * Default: []
     */
    java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups();
    /**
     * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
     * 
     * Default: ServerDeploymentConfig#OneAtATime
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig();
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * 
     * Default: an auto-generated name will be used
     */
    java.lang.String getDeploymentGroupName();
    /**
     * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * 
     * Default: no additional EC2 instances will be added to the Deployment Group
     */
    software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags();
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * 
     * Default: false
     */
    java.lang.Boolean getIgnorePollAlarmsFailure();
    /**
     * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
     * 
     * Default: true
     * 
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
     */
    java.lang.Boolean getInstallAgent();
    /**
     * The load balancer to place in front of this Deployment Group. Can be either a classic Elastic Load Balancer, or an Application Load Balancer / Network Load Balancer Target Group.
     * 
     * Default: the Deployment Group will not have a load balancer defined
     */
    software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer();
    /**
     * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
     * 
     * Default: no additional on-premise instances will be added to the Deployment Group
     */
    software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags();
    /**
     * The service Role of this Deployment Group. If you don't provide one, a new Role will be created.
     */
    software.amazon.awscdk.services.iam.Role getRole();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> _alarms;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerApplication _application;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig _autoRollback;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> _autoScalingGroups;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig _deploymentConfig;
        @javax.annotation.Nullable
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet _ec2InstanceTags;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePollAlarmsFailure;
        @javax.annotation.Nullable
        private java.lang.Boolean _installAgent;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.api.ILoadBalancer _loadBalancer;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.InstanceTagSet _onPremiseInstanceTags;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.Role _role;

        /**
         * Sets the value of Alarms
         * @param value The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
         * @return {@code this}
         */
        public Builder withAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> value) {
            this._alarms = value;
            return this;
        }
        /**
         * Sets the value of Application
         * @param value The CodeDeploy EC2/on-premise Application this Deployment Group belongs to. If you don't provide one, a new Application will be created.
         * @return {@code this}
         */
        public Builder withApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
            this._application = value;
            return this;
        }
        /**
         * Sets the value of AutoRollback
         * @param value The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        public Builder withAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }
        /**
         * Sets the value of AutoScalingGroups
         * @param value The auto-scaling groups belonging to this Deployment Group.
         * @return {@code this}
         */
        public Builder withAutoScalingGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> value) {
            this._autoScalingGroups = value;
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentGroupName = value;
            return this;
        }
        /**
         * Sets the value of Ec2InstanceTags
         * @param value All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        public Builder withEc2InstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this._ec2InstanceTags = value;
            return this;
        }
        /**
         * Sets the value of IgnorePollAlarmsFailure
         * @param value Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        public Builder withIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }
        /**
         * Sets the value of InstallAgent
         * @param value If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * @return {@code this}
         */
        public Builder withInstallAgent(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._installAgent = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancer
         * @param value The load balancer to place in front of this Deployment Group. Can be either a classic Elastic Load Balancer, or an Application Load Balancer / Network Load Balancer Target Group.
         * @return {@code this}
         */
        public Builder withLoadBalancer(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer value) {
            this._loadBalancer = value;
            return this;
        }
        /**
         * Sets the value of OnPremiseInstanceTags
         * @param value All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * @return {@code this}
         */
        public Builder withOnPremiseInstanceTags(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.InstanceTagSet value) {
            this._onPremiseInstanceTags = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The service Role of this Deployment Group. If you don't provide one, a new Role will be created.
         * @return {@code this}
         */
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.Role value) {
            this._role = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentGroupProps build() {
            return new ServerDeploymentGroupProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> $alarms = _alarms;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.IServerApplication $application = _application;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig $autoRollback = _autoRollback;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> $autoScalingGroups = _autoScalingGroups;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig $deploymentConfig = _deploymentConfig;
                @javax.annotation.Nullable
                private final java.lang.String $deploymentGroupName = _deploymentGroupName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.InstanceTagSet $ec2InstanceTags = _ec2InstanceTags;
                @javax.annotation.Nullable
                private final java.lang.Boolean $ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                @javax.annotation.Nullable
                private final java.lang.Boolean $installAgent = _installAgent;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.api.ILoadBalancer $loadBalancer = _loadBalancer;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.InstanceTagSet $onPremiseInstanceTags = _onPremiseInstanceTags;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.Role $role = _role;

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
                    return this.$autoScalingGroups;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
                    return this.$ec2InstanceTags;
                }

                @Override
                public java.lang.Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public java.lang.Boolean getInstallAgent() {
                    return this.$installAgent;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
                    return this.$onPremiseInstanceTags;
                }

                @Override
                public software.amazon.awscdk.services.iam.Role getRole() {
                    return this.$role;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("alarms", om.valueToTree(this.getAlarms()));
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("autoRollback", om.valueToTree(this.getAutoRollback()));
                    obj.set("autoScalingGroups", om.valueToTree(this.getAutoScalingGroups()));
                    obj.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    obj.set("ec2InstanceTags", om.valueToTree(this.getEc2InstanceTags()));
                    obj.set("ignorePollAlarmsFailure", om.valueToTree(this.getIgnorePollAlarmsFailure()));
                    obj.set("installAgent", om.valueToTree(this.getInstallAgent()));
                    obj.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
                    obj.set("onPremiseInstanceTags", om.valueToTree(this.getOnPremiseInstanceTags()));
                    obj.set("role", om.valueToTree(this.getRole()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * 
         * Default: []
         * 
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.Alarm> getAlarms() {
            return this.jsiiGet("alarms", java.util.List.class);
        }

        /**
         * The CodeDeploy EC2/on-premise Application this Deployment Group belongs to. If you don't provide one, a new Application will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.jsiiGet("autoRollback", software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class);
        }

        /**
         * The auto-scaling groups belonging to this Deployment Group.
         * 
         * Auto-scaling groups can also be added after the Deployment Group is created using the {@link #addAutoScalingGroup} method.
         * 
         * Default: []
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> getAutoScalingGroups() {
            return this.jsiiGet("autoScalingGroups", java.util.List.class);
        }

        /**
         * The EC2/on-premise Deployment Configuration to use for this Deployment Group.
         * 
         * Default: ServerDeploymentConfig#OneAtATime
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * 
         * Default: an auto-generated name will be used
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * All EC2 instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * 
         * Default: no additional EC2 instances will be added to the Deployment Group
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.InstanceTagSet getEc2InstanceTags() {
            return this.jsiiGet("ec2InstanceTags", software.amazon.awscdk.services.codedeploy.InstanceTagSet.class);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.jsiiGet("ignorePollAlarmsFailure", java.lang.Boolean.class);
        }

        /**
         * If you've provided any auto-scaling groups with the {@link #autoScalingGroups} property, you can set this property to add User Data that installs the CodeDeploy agent on the instances.
         * 
         * Default: true
         * 
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/codedeploy-agent-operations-install.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInstallAgent() {
            return this.jsiiGet("installAgent", java.lang.Boolean.class);
        }

        /**
         * The load balancer to place in front of this Deployment Group. Can be either a classic Elastic Load Balancer, or an Application Load Balancer / Network Load Balancer Target Group.
         * 
         * Default: the Deployment Group will not have a load balancer defined
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.api.ILoadBalancer getLoadBalancer() {
            return this.jsiiGet("loadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancer.class);
        }

        /**
         * All on-premise instances matching the given set of tags when a deployment occurs will be added to this Deployment Group.
         * 
         * Default: no additional on-premise instances will be added to the Deployment Group
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.InstanceTagSet getOnPremiseInstanceTags() {
            return this.jsiiGet("onPremiseInstanceTags", software.amazon.awscdk.services.codedeploy.InstanceTagSet.class);
        }

        /**
         * The service Role of this Deployment Group. If you don't provide one, a new Role will be created.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }
    }
}
