package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Group.
 * 
 * @see ILambdaDeploymentGroup#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:18:28.643Z")
public interface LambdaDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     */
    software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication();
    /**
     * The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
     */
    java.lang.String getDeploymentGroupName();

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupAttributes}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentGroupAttributes}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication _application;
        private java.lang.String _deploymentGroupName;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LambdaDeploymentGroupAttributes build() {
            return new LambdaDeploymentGroupAttributes() {
                private final software.amazon.awscdk.services.codedeploy.ILambdaApplication $application = java.util.Objects.requireNonNull(_application, "application is required");
                private final java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Lambda Deployment Group that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }
    }
}
