package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * @see IServerDeploymentGroup#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:06:42.623Z")
public interface ServerDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
     */
    software.amazon.awscdk.services.codedeploy.IServerApplication getApplication();
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
     */
    java.lang.String getDeploymentGroupName();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * 
     * Default: ServerDeploymentConfig#OneAtATime
     */
    software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupAttributes}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupAttributes}
     */
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.IServerApplication _application;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig _deploymentConfig;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
         * @return {@code this}
         */
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ServerDeploymentGroupAttributes build() {
            return new ServerDeploymentGroupAttributes() {
                private final software.amazon.awscdk.services.codedeploy.IServerApplication $application = java.util.Objects.requireNonNull(_application, "application is required");
                private final java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig $deploymentConfig = _deploymentConfig;

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    obj.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
         */
        @Override
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * 
         * Default: ServerDeploymentConfig#OneAtATime
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }
    }
}
