package software.amazon.awscdk.services.codedeploy;

/**
 * Construction properties for {@link LambdaDeploymentGroup}.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:19:43.960Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LambdaDeploymentGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment.
     * 
     * [disable-awslint:ref-via-interface] since we need to modify the alias CFN resource update policy
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.lambda.Alias getAlias();
    /**
     * The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
     * 
     * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
     * 
     * Default: []
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms();
    /**
     * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
     * 
     * Default: - One will be created for you.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication();
    /**
     * The auto-rollback configuration for this Deployment Group.
     * 
     * Default: - default AutoRollbackConfig.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * 
     * Default: LambdaDeploymentConfig#AllAtOnce
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig();
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     * 
     * Default: - An auto-generated name will be used.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDeploymentGroupName();
    /**
     * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
     * 
     * Default: false
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getIgnorePollAlarmsFailure();
    /**
     * The Lambda function to run after traffic routing starts.
     * 
     * Default: - None.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.lambda.IFunction getPostHook();
    /**
     * The Lambda function to run before traffic routing starts.
     * 
     * Default: - None.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.lambda.IFunction getPreHook();
    /**
     * The service Role of this Deployment Group.
     * 
     * Default: - A new Role will be created.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.lambda.Alias _alias;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> _alarms;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ILambdaApplication _application;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.AutoRollbackConfig _autoRollback;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig _deploymentConfig;
        @javax.annotation.Nullable
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private java.lang.Boolean _ignorePollAlarmsFailure;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.IFunction _postHook;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.lambda.IFunction _preHook;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.IRole _role;

        /**
         * Sets the value of Alias
         * @param value Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAlias(final software.amazon.awscdk.services.lambda.Alias value) {
            this._alias = java.util.Objects.requireNonNull(value, "alias is required");
            return this;
        }
        /**
         * Sets the value of Alarms
         * @param value The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAlarms(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> value) {
            this._alarms = value;
            return this;
        }
        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withApplication(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaApplication value) {
            this._application = value;
            return this;
        }
        /**
         * Sets the value of AutoRollback
         * @param value The auto-rollback configuration for this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAutoRollback(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig value) {
            this._autoRollback = value;
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeploymentGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._deploymentGroupName = value;
            return this;
        }
        /**
         * Sets the value of IgnorePollAlarmsFailure
         * @param value Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withIgnorePollAlarmsFailure(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._ignorePollAlarmsFailure = value;
            return this;
        }
        /**
         * Sets the value of PostHook
         * @param value The Lambda function to run after traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPostHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this._postHook = value;
            return this;
        }
        /**
         * Sets the value of PreHook
         * @param value The Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPreHook(@javax.annotation.Nullable final software.amazon.awscdk.services.lambda.IFunction value) {
            this._preHook = value;
            return this;
        }
        /**
         * Sets the value of Role
         * @param value The service Role of this Deployment Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRole(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IRole value) {
            this._role = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public LambdaDeploymentGroupProps build() {
            return new LambdaDeploymentGroupProps() {
                private final software.amazon.awscdk.services.lambda.Alias $alias = java.util.Objects.requireNonNull(_alias, "alias is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> $alarms = _alarms;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.ILambdaApplication $application = _application;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.AutoRollbackConfig $autoRollback = _autoRollback;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig $deploymentConfig = _deploymentConfig;
                @javax.annotation.Nullable
                private final java.lang.String $deploymentGroupName = _deploymentGroupName;
                @javax.annotation.Nullable
                private final java.lang.Boolean $ignorePollAlarmsFailure = _ignorePollAlarmsFailure;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.lambda.IFunction $postHook = _postHook;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.lambda.IFunction $preHook = _preHook;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.IRole $role = _role;

                @Override
                public software.amazon.awscdk.services.lambda.Alias getAlias() {
                    return this.$alias;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
                    return this.$alarms;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
                    return this.$application;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
                    return this.$autoRollback;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public java.lang.Boolean getIgnorePollAlarmsFailure() {
                    return this.$ignorePollAlarmsFailure;
                }

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getPostHook() {
                    return this.$postHook;
                }

                @Override
                public software.amazon.awscdk.services.lambda.IFunction getPreHook() {
                    return this.$preHook;
                }

                @Override
                public software.amazon.awscdk.services.iam.IRole getRole() {
                    return this.$role;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("alias", om.valueToTree(this.getAlias()));
                    if (this.getAlarms() != null) {
                        obj.set("alarms", om.valueToTree(this.getAlarms()));
                    }
                    if (this.getApplication() != null) {
                        obj.set("application", om.valueToTree(this.getApplication()));
                    }
                    if (this.getAutoRollback() != null) {
                        obj.set("autoRollback", om.valueToTree(this.getAutoRollback()));
                    }
                    if (this.getDeploymentConfig() != null) {
                        obj.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                    }
                    if (this.getDeploymentGroupName() != null) {
                        obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    }
                    if (this.getIgnorePollAlarmsFailure() != null) {
                        obj.set("ignorePollAlarmsFailure", om.valueToTree(this.getIgnorePollAlarmsFailure()));
                    }
                    if (this.getPostHook() != null) {
                        obj.set("postHook", om.valueToTree(this.getPostHook()));
                    }
                    if (this.getPreHook() != null) {
                        obj.set("preHook", om.valueToTree(this.getPreHook()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree(this.getRole()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Lambda Alias to shift traffic. Updating the version of the alias will trigger a CodeDeploy deployment.
         * 
         * [disable-awslint:ref-via-interface] since we need to modify the alias CFN resource update policy
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.lambda.Alias getAlias() {
            return this.jsiiGet("alias", software.amazon.awscdk.services.lambda.Alias.class);
        }

        /**
         * The CloudWatch alarms associated with this Deployment Group. CodeDeploy will stop (and optionally roll back) a deployment if during it any of the alarms trigger.
         * 
         * Alarms can also be added after the Deployment Group is created using the {@link #addAlarm} method.
         * 
         * Default: []
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-create-alarms.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.cloudwatch.IAlarm> getAlarms() {
            return this.jsiiGet("alarms", java.util.List.class);
        }

        /**
         * The reference to the CodeDeploy Lambda Application that this Deployment Group belongs to.
         * 
         * Default: - One will be created for you.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ILambdaApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.ILambdaApplication.class);
        }

        /**
         * The auto-rollback configuration for this Deployment Group.
         * 
         * Default: - default AutoRollbackConfig.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.AutoRollbackConfig getAutoRollback() {
            return this.jsiiGet("autoRollback", software.amazon.awscdk.services.codedeploy.AutoRollbackConfig.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * 
         * Default: LambdaDeploymentConfig#AllAtOnce
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy Deployment Group.
         * 
         * Default: - An auto-generated name will be used.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * Whether to continue a deployment even if fetching the alarm status from CloudWatch failed.
         * 
         * Default: false
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getIgnorePollAlarmsFailure() {
            return this.jsiiGet("ignorePollAlarmsFailure", java.lang.Boolean.class);
        }

        /**
         * The Lambda function to run after traffic routing starts.
         * 
         * Default: - None.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.IFunction getPostHook() {
            return this.jsiiGet("postHook", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * The Lambda function to run before traffic routing starts.
         * 
         * Default: - None.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.lambda.IFunction getPreHook() {
            return this.jsiiGet("preHook", software.amazon.awscdk.services.lambda.IFunction.class);
        }

        /**
         * The service Role of this Deployment Group.
         * 
         * Default: - A new Role will be created.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }
    }
}
