package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Group.
 * 
 * EXPERIMENTAL
 * 
 * @see IServerDeploymentGroup#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T17:10:40.919Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ServerDeploymentGroupAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codedeploy.IServerApplication getApplication();
    /**
     * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDeploymentGroupName();
    /**
     * The Deployment Configuration this Deployment Group uses.
     * 
     * Default: ServerDeploymentConfig#OneAtATime
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig();

    /**
     * @return a {@link Builder} of {@link ServerDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ServerDeploymentGroupAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.codedeploy.IServerApplication _application;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig _deploymentConfig;

        /**
         * Sets the value of Application
         * @param value The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withApplication(final software.amazon.awscdk.services.codedeploy.IServerApplication value) {
            this._application = java.util.Objects.requireNonNull(value, "application is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentConfig
         * @param value The Deployment Configuration this Deployment Group uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeploymentConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig value) {
            this._deploymentConfig = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServerDeploymentGroupAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ServerDeploymentGroupAttributes build() {
            return new ServerDeploymentGroupAttributes() {
                private final software.amazon.awscdk.services.codedeploy.IServerApplication $application = java.util.Objects.requireNonNull(_application, "application is required");
                private final java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig $deploymentConfig = _deploymentConfig;

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
                    return this.$application;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
                    return this.$deploymentConfig;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("application", om.valueToTree(this.getApplication()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    if (this.getDeploymentConfig() != null) {
                        obj.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.ServerDeploymentGroupAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The reference to the CodeDeploy EC2/on-premise Application that this Deployment Group belongs to.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.codedeploy.IServerApplication getApplication() {
            return this.jsiiGet("application", software.amazon.awscdk.services.codedeploy.IServerApplication.class);
        }

        /**
         * The physical, human-readable name of the CodeDeploy EC2/on-premise Deployment Group that we are referencing.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The Deployment Configuration this Deployment Group uses.
         * 
         * Default: ServerDeploymentConfig#OneAtATime
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig getDeploymentConfig() {
            return this.jsiiGet("deploymentConfig", software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class);
        }
    }
}
