/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnDeploymentGroupProps
extends JsiiSerializable {
    public String getApplicationName();

    public String getServiceRoleArn();

    public Object getAlarmConfiguration();

    public Object getAutoRollbackConfiguration();

    public List<String> getAutoScalingGroups();

    public Object getDeployment();

    public String getDeploymentConfigName();

    public String getDeploymentGroupName();

    public Object getDeploymentStyle();

    public Object getEc2TagFilters();

    public Object getEc2TagSet();

    public Object getLoadBalancerInfo();

    public Object getOnPremisesInstanceTagFilters();

    public Object getOnPremisesTagSet();

    public Object getTriggerConfigurations();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _applicationName;
        private String _serviceRoleArn;
        @Nullable
        private Object _alarmConfiguration;
        @Nullable
        private Object _autoRollbackConfiguration;
        @Nullable
        private List<String> _autoScalingGroups;
        @Nullable
        private Object _deployment;
        @Nullable
        private String _deploymentConfigName;
        @Nullable
        private String _deploymentGroupName;
        @Nullable
        private Object _deploymentStyle;
        @Nullable
        private Object _ec2TagFilters;
        @Nullable
        private Object _ec2TagSet;
        @Nullable
        private Object _loadBalancerInfo;
        @Nullable
        private Object _onPremisesInstanceTagFilters;
        @Nullable
        private Object _onPremisesTagSet;
        @Nullable
        private Object _triggerConfigurations;

        public Builder withApplicationName(String value) {
            this._applicationName = Objects.requireNonNull(value, "applicationName is required");
            return this;
        }

        public Builder withServiceRoleArn(String value) {
            this._serviceRoleArn = Objects.requireNonNull(value, "serviceRoleArn is required");
            return this;
        }

        public Builder withAlarmConfiguration(@Nullable IResolvable value) {
            this._alarmConfiguration = value;
            return this;
        }

        public Builder withAlarmConfiguration(@Nullable CfnDeploymentGroup.AlarmConfigurationProperty value) {
            this._alarmConfiguration = value;
            return this;
        }

        public Builder withAutoRollbackConfiguration(@Nullable IResolvable value) {
            this._autoRollbackConfiguration = value;
            return this;
        }

        public Builder withAutoRollbackConfiguration(@Nullable CfnDeploymentGroup.AutoRollbackConfigurationProperty value) {
            this._autoRollbackConfiguration = value;
            return this;
        }

        public Builder withAutoScalingGroups(@Nullable List<String> value) {
            this._autoScalingGroups = value;
            return this;
        }

        public Builder withDeployment(@Nullable IResolvable value) {
            this._deployment = value;
            return this;
        }

        public Builder withDeployment(@Nullable CfnDeploymentGroup.DeploymentProperty value) {
            this._deployment = value;
            return this;
        }

        public Builder withDeploymentConfigName(@Nullable String value) {
            this._deploymentConfigName = value;
            return this;
        }

        public Builder withDeploymentGroupName(@Nullable String value) {
            this._deploymentGroupName = value;
            return this;
        }

        public Builder withDeploymentStyle(@Nullable IResolvable value) {
            this._deploymentStyle = value;
            return this;
        }

        public Builder withDeploymentStyle(@Nullable CfnDeploymentGroup.DeploymentStyleProperty value) {
            this._deploymentStyle = value;
            return this;
        }

        public Builder withEc2TagFilters(@Nullable IResolvable value) {
            this._ec2TagFilters = value;
            return this;
        }

        public Builder withEc2TagFilters(@Nullable List<Object> value) {
            this._ec2TagFilters = value;
            return this;
        }

        public Builder withEc2TagSet(@Nullable IResolvable value) {
            this._ec2TagSet = value;
            return this;
        }

        public Builder withEc2TagSet(@Nullable CfnDeploymentGroup.EC2TagSetProperty value) {
            this._ec2TagSet = value;
            return this;
        }

        public Builder withLoadBalancerInfo(@Nullable IResolvable value) {
            this._loadBalancerInfo = value;
            return this;
        }

        public Builder withLoadBalancerInfo(@Nullable CfnDeploymentGroup.LoadBalancerInfoProperty value) {
            this._loadBalancerInfo = value;
            return this;
        }

        public Builder withOnPremisesInstanceTagFilters(@Nullable IResolvable value) {
            this._onPremisesInstanceTagFilters = value;
            return this;
        }

        public Builder withOnPremisesInstanceTagFilters(@Nullable List<Object> value) {
            this._onPremisesInstanceTagFilters = value;
            return this;
        }

        public Builder withOnPremisesTagSet(@Nullable IResolvable value) {
            this._onPremisesTagSet = value;
            return this;
        }

        public Builder withOnPremisesTagSet(@Nullable CfnDeploymentGroup.OnPremisesTagSetProperty value) {
            this._onPremisesTagSet = value;
            return this;
        }

        public Builder withTriggerConfigurations(@Nullable IResolvable value) {
            this._triggerConfigurations = value;
            return this;
        }

        public Builder withTriggerConfigurations(@Nullable List<Object> value) {
            this._triggerConfigurations = value;
            return this;
        }

        public CfnDeploymentGroupProps build() {
            return new CfnDeploymentGroupProps(){
                private final String $applicationName;
                private final String $serviceRoleArn;
                @Nullable
                private final Object $alarmConfiguration;
                @Nullable
                private final Object $autoRollbackConfiguration;
                @Nullable
                private final List<String> $autoScalingGroups;
                @Nullable
                private final Object $deployment;
                @Nullable
                private final String $deploymentConfigName;
                @Nullable
                private final String $deploymentGroupName;
                @Nullable
                private final Object $deploymentStyle;
                @Nullable
                private final Object $ec2TagFilters;
                @Nullable
                private final Object $ec2TagSet;
                @Nullable
                private final Object $loadBalancerInfo;
                @Nullable
                private final Object $onPremisesInstanceTagFilters;
                @Nullable
                private final Object $onPremisesTagSet;
                @Nullable
                private final Object $triggerConfigurations;
                {
                    this.$applicationName = Objects.requireNonNull(_applicationName, "applicationName is required");
                    this.$serviceRoleArn = Objects.requireNonNull(_serviceRoleArn, "serviceRoleArn is required");
                    this.$alarmConfiguration = _alarmConfiguration;
                    this.$autoRollbackConfiguration = _autoRollbackConfiguration;
                    this.$autoScalingGroups = _autoScalingGroups;
                    this.$deployment = _deployment;
                    this.$deploymentConfigName = _deploymentConfigName;
                    this.$deploymentGroupName = _deploymentGroupName;
                    this.$deploymentStyle = _deploymentStyle;
                    this.$ec2TagFilters = _ec2TagFilters;
                    this.$ec2TagSet = _ec2TagSet;
                    this.$loadBalancerInfo = _loadBalancerInfo;
                    this.$onPremisesInstanceTagFilters = _onPremisesInstanceTagFilters;
                    this.$onPremisesTagSet = _onPremisesTagSet;
                    this.$triggerConfigurations = _triggerConfigurations;
                }

                @Override
                public String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public String getServiceRoleArn() {
                    return this.$serviceRoleArn;
                }

                @Override
                public Object getAlarmConfiguration() {
                    return this.$alarmConfiguration;
                }

                @Override
                public Object getAutoRollbackConfiguration() {
                    return this.$autoRollbackConfiguration;
                }

                @Override
                public List<String> getAutoScalingGroups() {
                    return this.$autoScalingGroups;
                }

                @Override
                public Object getDeployment() {
                    return this.$deployment;
                }

                @Override
                public String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                @Override
                public String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public Object getDeploymentStyle() {
                    return this.$deploymentStyle;
                }

                @Override
                public Object getEc2TagFilters() {
                    return this.$ec2TagFilters;
                }

                @Override
                public Object getEc2TagSet() {
                    return this.$ec2TagSet;
                }

                @Override
                public Object getLoadBalancerInfo() {
                    return this.$loadBalancerInfo;
                }

                @Override
                public Object getOnPremisesInstanceTagFilters() {
                    return this.$onPremisesInstanceTagFilters;
                }

                @Override
                public Object getOnPremisesTagSet() {
                    return this.$onPremisesTagSet;
                }

                @Override
                public Object getTriggerConfigurations() {
                    return this.$triggerConfigurations;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree((Object)this.getApplicationName()));
                    obj.set("serviceRoleArn", om.valueToTree((Object)this.getServiceRoleArn()));
                    if (this.getAlarmConfiguration() != null) {
                        obj.set("alarmConfiguration", om.valueToTree(this.getAlarmConfiguration()));
                    }
                    if (this.getAutoRollbackConfiguration() != null) {
                        obj.set("autoRollbackConfiguration", om.valueToTree(this.getAutoRollbackConfiguration()));
                    }
                    if (this.getAutoScalingGroups() != null) {
                        obj.set("autoScalingGroups", om.valueToTree(this.getAutoScalingGroups()));
                    }
                    if (this.getDeployment() != null) {
                        obj.set("deployment", om.valueToTree(this.getDeployment()));
                    }
                    if (this.getDeploymentConfigName() != null) {
                        obj.set("deploymentConfigName", om.valueToTree((Object)this.getDeploymentConfigName()));
                    }
                    if (this.getDeploymentGroupName() != null) {
                        obj.set("deploymentGroupName", om.valueToTree((Object)this.getDeploymentGroupName()));
                    }
                    if (this.getDeploymentStyle() != null) {
                        obj.set("deploymentStyle", om.valueToTree(this.getDeploymentStyle()));
                    }
                    if (this.getEc2TagFilters() != null) {
                        obj.set("ec2TagFilters", om.valueToTree(this.getEc2TagFilters()));
                    }
                    if (this.getEc2TagSet() != null) {
                        obj.set("ec2TagSet", om.valueToTree(this.getEc2TagSet()));
                    }
                    if (this.getLoadBalancerInfo() != null) {
                        obj.set("loadBalancerInfo", om.valueToTree(this.getLoadBalancerInfo()));
                    }
                    if (this.getOnPremisesInstanceTagFilters() != null) {
                        obj.set("onPremisesInstanceTagFilters", om.valueToTree(this.getOnPremisesInstanceTagFilters()));
                    }
                    if (this.getOnPremisesTagSet() != null) {
                        obj.set("onPremisesTagSet", om.valueToTree(this.getOnPremisesTagSet()));
                    }
                    if (this.getTriggerConfigurations() != null) {
                        obj.set("triggerConfigurations", om.valueToTree(this.getTriggerConfigurations()));
                    }
                    return obj;
                }
            };
        }
    }
}

