package software.amazon.awscdk.services.codedeploy;

/**
 * The configuration for automatically rolling back deployments in a given Deployment Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:43:37.898Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoRollbackConfig extends software.amazon.jsii.JsiiSerializable {
    /**
     * Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
     * 
     * Default: true if you've provided any Alarms with the `alarms` property, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getDeploymentInAlarm();
    /**
     * Whether to automatically roll back a deployment that fails.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getFailedDeployment();
    /**
     * Whether to automatically roll back a deployment that was manually stopped.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getStoppedDeployment();

    /**
     * @return a {@link Builder} of {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AutoRollbackConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _deploymentInAlarm;
        @javax.annotation.Nullable
        private java.lang.Boolean _failedDeployment;
        @javax.annotation.Nullable
        private java.lang.Boolean _stoppedDeployment;

        /**
         * Sets the value of DeploymentInAlarm
         * @param value Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentInAlarm(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deploymentInAlarm = value;
            return this;
        }
        /**
         * Sets the value of FailedDeployment
         * @param value Whether to automatically roll back a deployment that fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFailedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._failedDeployment = value;
            return this;
        }
        /**
         * Sets the value of StoppedDeployment
         * @param value Whether to automatically roll back a deployment that was manually stopped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStoppedDeployment(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._stoppedDeployment = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoRollbackConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AutoRollbackConfig build() {
            return new AutoRollbackConfig() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $deploymentInAlarm = _deploymentInAlarm;
                @javax.annotation.Nullable
                private final java.lang.Boolean $failedDeployment = _failedDeployment;
                @javax.annotation.Nullable
                private final java.lang.Boolean $stoppedDeployment = _stoppedDeployment;

                @Override
                public java.lang.Boolean getDeploymentInAlarm() {
                    return this.$deploymentInAlarm;
                }

                @Override
                public java.lang.Boolean getFailedDeployment() {
                    return this.$failedDeployment;
                }

                @Override
                public java.lang.Boolean getStoppedDeployment() {
                    return this.$stoppedDeployment;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDeploymentInAlarm() != null) {
                        obj.set("deploymentInAlarm", om.valueToTree(this.getDeploymentInAlarm()));
                    }
                    if (this.getFailedDeployment() != null) {
                        obj.set("failedDeployment", om.valueToTree(this.getFailedDeployment()));
                    }
                    if (this.getStoppedDeployment() != null) {
                        obj.set("stoppedDeployment", om.valueToTree(this.getStoppedDeployment()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.AutoRollbackConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Whether to automatically roll back a deployment during which one of the configured CloudWatch alarms for this Deployment Group went off.
         * 
         * Default: true if you've provided any Alarms with the `alarms` property, false otherwise
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getDeploymentInAlarm() {
            return this.jsiiGet("deploymentInAlarm", java.lang.Boolean.class);
        }

        /**
         * Whether to automatically roll back a deployment that fails.
         * 
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getFailedDeployment() {
            return this.jsiiGet("failedDeployment", java.lang.Boolean.class);
        }

        /**
         * Whether to automatically roll back a deployment that was manually stopped.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getStoppedDeployment() {
            return this.jsiiGet("stoppedDeployment", java.lang.Boolean.class);
        }
    }
}
