package software.amazon.awscdk.services.codedeploy;

/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 * 
 * @see LambdaDeploymentConfig#export
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:43:37.923Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDeploymentConfigImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentConfigName();

    /**
     * @return a {@link Builder} of {@link LambdaDeploymentConfigImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LambdaDeploymentConfigImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _deploymentConfigName;

        /**
         * Sets the value of DeploymentConfigName
         * @param value The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentConfigName(final java.lang.String value) {
            this._deploymentConfigName = java.util.Objects.requireNonNull(value, "deploymentConfigName is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDeploymentConfigImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LambdaDeploymentConfigImportProps build() {
            return new LambdaDeploymentConfigImportProps() {
                private final java.lang.String $deploymentConfigName = java.util.Objects.requireNonNull(_deploymentConfigName, "deploymentConfigName is required");

                @Override
                public java.lang.String getDeploymentConfigName() {
                    return this.$deploymentConfigName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.LambdaDeploymentConfigImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration that we are referencing.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDeploymentConfigName() {
            return this.jsiiGet("deploymentConfigName", java.lang.String.class);
        }
    }
}
